/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.transformer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.jxls.controller.WorkbookTransformationController;
import org.jxls.controller.WorkbookTransformationControllerImpl;
import org.jxls.exception.ParsePropertyException;
import org.jxls.exception.TaglibRegistrationException;
import org.jxls.formula.CommonFormulaResolver;
import org.jxls.formula.Formula;
import org.jxls.formula.FormulaResolver;
import org.jxls.processor.CellProcessor;
import org.jxls.processor.PropertyPreprocessor;
import org.jxls.processor.RowProcessor;
import org.jxls.tag.Taglib;
import org.jxls.transformer.Configuration;
import org.jxls.transformer.Sheet;
import org.jxls.transformer.SheetTransformer;
import org.jxls.transformer.Workbook;
import org.jxls.util.Util;

public class XLSTransformer {
    protected final Log log = LogFactory.getLog(this.getClass());
    private List propertyPreprocessors = new ArrayList();
    private List rowProcessors = new ArrayList();
    private List cellProcessors = new ArrayList();
    private Map taglibs = new HashMap();
    private short[] columnsToHide;
    private Set spreadsheetsToHide = new HashSet();
    private Map spreadsheetsToRename = new HashMap();
    private String[] columnPropertyNamesToHide;
    Map customTags = new HashMap();
    private Set fixedSizeCollections = new HashSet();
    private Set groupedCollections = new HashSet();
    private Configuration configuration;
    private WorkbookTransformationController workbookTransformationController;
    private FormulaResolver formulaResolver;

    public void registerPropertyPreprocessor(PropertyPreprocessor propPreprocessor) {
        if (propPreprocessor != null) {
            this.propertyPreprocessors.add(propPreprocessor);
        }
    }

    public void registerRowProcessor(RowProcessor rowProcessor) {
        if (rowProcessor != null) {
            this.rowProcessors.add(rowProcessor);
        }
    }

    public void registerCellProcessor(CellProcessor cellProcessor) {
        if (cellProcessor != null) {
            this.cellProcessors.add(cellProcessor);
        }
    }

    public void markAsFixedSizeCollection(String collectionName) {
        this.fixedSizeCollections.add(collectionName);
    }

    public void registerTaglib(String prefix, Taglib taglib) {
        if (this.taglibs.containsKey(prefix)) {
            throw new TaglibRegistrationException("Tag library with prefix '" + prefix + "' already registered");
        }
        this.taglibs.put(prefix, taglib);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public XLSTransformer() {
        this.configuration = new Configuration();
    }

    public XLSTransformer(Configuration configuration) {
        this.configuration = configuration != null ? configuration : new Configuration();
    }

    public FormulaResolver getFormulaResolver() {
        return this.formulaResolver;
    }

    public void setFormulaResolver(FormulaResolver formulaResolver) {
        this.formulaResolver = formulaResolver;
    }

    public boolean isJexlInnerCollectionsAccess() {
        return this.configuration.isJexlInnerCollectionsAccess();
    }

    public void setJexlInnerCollectionsAccess(boolean jexlInnerCollectionsAccess) {
        this.configuration.setJexlInnerCollectionsAccess(jexlInnerCollectionsAccess);
    }

    public void groupCollection(String collectionName) {
        this.groupedCollections.add(collectionName);
    }

    public void transformXLS(String srcFilePath, Map beanParams, String destFilePath) throws ParsePropertyException, IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(srcFilePath));
        HSSFWorkbook workbook = this.transformXLS(is, beanParams);
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(destFilePath));
        workbook.write((OutputStream)os);
        ((InputStream)is).close();
        ((OutputStream)os).flush();
        ((OutputStream)os).close();
    }

    public HSSFWorkbook transformXLS(InputStream is, Map beanParams) throws ParsePropertyException {
        HSSFWorkbook hssfWorkbook = null;
        try {
            POIFSFileSystem fs = new POIFSFileSystem(is);
            hssfWorkbook = new HSSFWorkbook(fs);
            Workbook workbook = this.createWorkbook(hssfWorkbook);
            this.workbookTransformationController = new WorkbookTransformationControllerImpl(workbook);
            this.preprocess(hssfWorkbook);
            SheetTransformer sheetTransformer = new SheetTransformer(this.fixedSizeCollections, this.groupedCollections, this.rowProcessors, this.cellProcessors, this.configuration);
            for (int sheetNo = 0; sheetNo < hssfWorkbook.getNumberOfSheets(); ++sheetNo) {
                String spreadsheetName = hssfWorkbook.getSheetName(sheetNo);
                if (!this.isSpreadsheetToHide(spreadsheetName)) {
                    if (this.isSpreadsheetToRename(spreadsheetName)) {
                        hssfWorkbook.setSheetName(sheetNo, this.getSpreadsheetToReName(spreadsheetName));
                    }
                    Sheet sheet = workbook.getSheetAt(sheetNo);
                    sheetTransformer.transformSheet(this.workbookTransformationController, sheet, beanParams);
                    continue;
                }
                hssfWorkbook.removeSheetAt(sheetNo);
                --sheetNo;
            }
            this.updateFormulas();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return hssfWorkbook;
    }

    public HSSFWorkbook transformMultipleSheetsList(InputStream is, List objects, List newSheetNames, String beanName, Map beanParams, int startSheetNum) throws ParsePropertyException {
        HSSFWorkbook hssfWorkbook = null;
        try {
            if (beanParams != null && beanParams.containsKey(beanName)) {
                throw new IllegalArgumentException("Selected bean name '" + beanName + "' already exists in the bean map");
            }
            if (beanName == null) {
                throw new IllegalArgumentException("Bean name must not be null");
            }
            if (beanParams == null) {
                beanParams = new HashMap();
            }
            POIFSFileSystem fs = new POIFSFileSystem(is);
            hssfWorkbook = new HSSFWorkbook(fs);
            this.preprocess(hssfWorkbook);
            Workbook workbook = this.createWorkbook(hssfWorkbook);
            this.workbookTransformationController = new WorkbookTransformationControllerImpl(workbook);
            SheetTransformer sheetTransformer = new SheetTransformer(this.fixedSizeCollections, this.groupedCollections, this.rowProcessors, this.cellProcessors, this.configuration);
            String templateSheetName = "InternalTemplateSheetName";
            for (int sheetNo = 0; sheetNo < hssfWorkbook.getNumberOfSheets(); ++sheetNo) {
                String spreadsheetName = hssfWorkbook.getSheetName(sheetNo);
                if (!this.isSpreadsheetToHide(spreadsheetName)) {
                    if (this.isSpreadsheetToRename(spreadsheetName)) {
                        hssfWorkbook.setSheetName(sheetNo, this.getSpreadsheetToReName(spreadsheetName));
                    }
                    HSSFSheet hssfSheet = hssfWorkbook.getSheetAt(sheetNo);
                    if (startSheetNum == sheetNo && objects != null && !objects.isEmpty()) {
                        Object firstBean = objects.get(0);
                        beanParams.put(beanName, firstBean);
                        hssfWorkbook.setSheetName(sheetNo, (String)newSheetNames.get(0));
                        HSSFSheet templateSheet = hssfWorkbook.createSheet("InternalTemplateSheetName");
                        Util.copySheets(templateSheet, hssfSheet);
                        Sheet sheet = workbook.getSheetAt(sheetNo);
                        sheetTransformer.transformSheet(this.workbookTransformationController, sheet, beanParams);
                        for (int i = 1; i < objects.size(); ++i) {
                            Object bean = objects.get(i);
                            beanParams.put(beanName, bean);
                            HSSFSheet newSheet = hssfWorkbook.createSheet((String)newSheetNames.get(i));
                            Util.copySheets(newSheet, templateSheet);
                            sheet = new Sheet(hssfWorkbook, newSheet, this.configuration);
                            workbook.addSheet(sheet);
                            sheetTransformer.transformSheet(this.workbookTransformationController, sheet, beanParams);
                        }
                        hssfWorkbook.removeSheetAt(hssfWorkbook.getSheetIndex("InternalTemplateSheetName"));
                        beanParams.remove(beanName);
                        continue;
                    }
                    Sheet sheet = workbook.getSheetAt(sheetNo);
                    sheetTransformer.transformSheet(this.workbookTransformationController, sheet, beanParams);
                    continue;
                }
                hssfWorkbook.removeSheetAt(sheetNo);
                workbook.getSheets().remove(sheetNo);
                --sheetNo;
            }
            this.updateFormulas();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return hssfWorkbook;
    }

    private Workbook createWorkbook(HSSFWorkbook hssfWorkbook) {
        Workbook workbook = new Workbook(hssfWorkbook);
        for (int sheetNo = 0; sheetNo < hssfWorkbook.getNumberOfSheets(); ++sheetNo) {
            HSSFSheet hssfSheet = hssfWorkbook.getSheetAt(sheetNo);
            workbook.addSheet(new Sheet(hssfWorkbook, hssfSheet, this.configuration));
        }
        return workbook;
    }

    private void updateFormulas() {
        if (this.formulaResolver == null) {
            this.formulaResolver = new CommonFormulaResolver();
        }
        List formulas = this.workbookTransformationController.getWorkbook().getFormulas();
        for (int i = 0; i < formulas.size(); ++i) {
            Formula formula = (Formula)formulas.get(i);
            String formulaString = this.formulaResolver.resolve(formula, null);
            HSSFRow hssfRow = formula.getSheet().getHssfSheet().getRow(formula.getRowNum().intValue());
            HSSFCell hssfCell = hssfRow.getCell(formula.getCellNum().shortValue());
            if (formulaString == null) continue;
            hssfCell.setCellFormula(formulaString);
        }
    }

    private void preprocess(HSSFWorkbook workbook) {
        this.hideColumns(workbook);
        this.hideColumnsByPropertyName(workbook);
        for (int sheet_no = 0; sheet_no < workbook.getNumberOfSheets(); ++sheet_no) {
            HSSFSheet sheet = workbook.getSheetAt(sheet_no);
            for (int i = sheet.getFirstRowNum(); i <= sheet.getLastRowNum(); ++i) {
                HSSFRow hssfRow = sheet.getRow(i);
                if (hssfRow == null) continue;
                for (short j = hssfRow.getFirstCellNum(); j <= hssfRow.getLastCellNum(); j = (short)(j + 1)) {
                    HSSFCell cell = hssfRow.getCell(j);
                    if (cell == null || cell.getCellType() != 1) continue;
                    String value = cell.getStringCellValue();
                    for (int k = 0; k < this.propertyPreprocessors.size(); ++k) {
                        PropertyPreprocessor propertyPreprocessor = (PropertyPreprocessor)this.propertyPreprocessors.get(k);
                        String newValue = propertyPreprocessor.processProperty(value);
                        if (newValue == null) continue;
                        cell.setCellValue(newValue);
                    }
                }
            }
        }
    }

    private void hideColumns(HSSFWorkbook workbook) {
        if (this.columnsToHide != null) {
            for (int i = 0; i < this.columnsToHide.length; ++i) {
                short column = this.columnsToHide[i];
                for (int sheet_no = 0; sheet_no < workbook.getNumberOfSheets(); ++sheet_no) {
                    HSSFSheet sheet = workbook.getSheetAt(sheet_no);
                    sheet.setColumnWidth(column, (short)0);
                }
            }
        }
    }

    private void hideColumnsByPropertyName(HSSFWorkbook workbook) {
        if (this.columnPropertyNamesToHide == null) {
            return;
        }
        for (int sheet_no = 0; sheet_no < workbook.getNumberOfSheets(); ++sheet_no) {
            HSSFSheet sheet = workbook.getSheetAt(sheet_no);
            for (int i = sheet.getFirstRowNum(); i <= sheet.getLastRowNum(); ++i) {
                HSSFRow hssfRow = sheet.getRow(i);
                if (hssfRow == null) continue;
                block2: for (short j = hssfRow.getFirstCellNum(); j <= hssfRow.getLastCellNum(); j = (short)(j + 1)) {
                    HSSFCell cell = hssfRow.getCell(j);
                    if (cell == null || cell.getCellType() != 1) continue;
                    String value = cell.getStringCellValue();
                    for (int prptIndx = 0; prptIndx < this.columnPropertyNamesToHide.length; ++prptIndx) {
                        if (value == null || value.indexOf(this.columnPropertyNamesToHide[prptIndx]) == -1) continue;
                        sheet.setColumnWidth(j, (short)0);
                        continue block2;
                    }
                }
            }
        }
    }

    public short[] getColumnsToHide() {
        return this.columnsToHide;
    }

    public void setColumnsToHide(short[] columnsToHide) {
        this.columnsToHide = columnsToHide;
    }

    public String[] getColumnPropertyNamesToHide() {
        return this.columnPropertyNamesToHide;
    }

    public void setColumnPropertyNamesToHide(String[] columnPropertyNamesToHide) {
        this.columnPropertyNamesToHide = columnPropertyNamesToHide;
    }

    public void setSpreadsheetsToHide(String[] names) {
        this.spreadsheetsToHide.clear();
        for (int i = 0; i < names.length; ++i) {
            this.spreadsheetsToHide.add(names[i]);
        }
    }

    public void setSpreadsheetToRename(String name, String newName) {
        this.spreadsheetsToRename.put(name, newName);
    }

    protected boolean isSpreadsheetToHide(String name) {
        return this.spreadsheetsToHide.contains(name);
    }

    protected boolean isSpreadsheetToRename(String name) {
        return this.spreadsheetsToRename.containsKey(name);
    }

    protected String getSpreadsheetToReName(String name) {
        String newName = (String)this.spreadsheetsToRename.get(name);
        if (newName != null) {
            return newName;
        }
        return name;
    }
}

