/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.transformer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.jxls.transformer.Configuration;
import org.jxls.transformer.Sheet;
import org.jxls.util.SheetHelper;

public class Workbook {
    List sheets = new ArrayList();
    HSSFWorkbook hssfWorkbook;
    Configuration configuration = new Configuration();

    public Workbook(HSSFWorkbook hssfWorkbook) {
        this.hssfWorkbook = hssfWorkbook;
    }

    public Workbook(HSSFWorkbook hssfWorkbook, Configuration configuration) {
        this.hssfWorkbook = hssfWorkbook;
        this.configuration = configuration;
    }

    public Workbook(HSSFWorkbook hssfWorkbook, List sheets) {
        this.hssfWorkbook = hssfWorkbook;
        this.sheets = sheets;
    }

    public Workbook(HSSFWorkbook hssfWorkbook, List sheets, Configuration configuration) {
        this.hssfWorkbook = hssfWorkbook;
        this.sheets = sheets;
        this.configuration = configuration;
    }

    public HSSFWorkbook getHssfWorkbook() {
        return this.hssfWorkbook;
    }

    public void setHssfWorkbook(HSSFWorkbook hssfWorkbook) {
        this.hssfWorkbook = hssfWorkbook;
    }

    public void addSheet(Sheet sheet) {
        this.sheets.add(sheet);
        sheet.setWorkbook(this);
    }

    public Map getListRanges() {
        HashMap listRanges = new HashMap();
        for (int i = 0; i < this.sheets.size(); ++i) {
            Sheet sheet = (Sheet)this.sheets.get(i);
            listRanges.putAll(sheet.getListRanges());
        }
        return listRanges;
    }

    public List getFormulas() {
        ArrayList formulas = new ArrayList();
        for (int i = 0; i < this.sheets.size(); ++i) {
            Sheet sheet = (Sheet)this.sheets.get(i);
            formulas.addAll(SheetHelper.findFormulas(sheet));
        }
        return formulas;
    }

    public List getSheets() {
        return this.sheets;
    }

    public int getNumberOfSheets() {
        return this.sheets.size();
    }

    public Sheet getSheetAt(int sheetNo) {
        return (Sheet)this.sheets.get(sheetNo);
    }
}

