/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.transformer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jxls.controller.SheetTransformationController;
import org.jxls.parser.Cell;
import org.jxls.processor.CellProcessor;
import org.jxls.transformation.ResultTransformation;
import org.jxls.transformer.BaseRowTransformer;
import org.jxls.transformer.CellTransformer;
import org.jxls.transformer.Configuration;
import org.jxls.transformer.Row;
import org.jxls.transformer.Sheet;
import org.jxls.transformer.SheetTransformer;

public class SimpleRowTransformer
extends BaseRowTransformer {
    Configuration configuration;
    List cellProcessors;
    List cells = new ArrayList();
    private ResultTransformation resultTransformation;

    public SimpleRowTransformer(Row row, List cellProcessors, Configuration configuration) {
        this.row = row;
        this.cellProcessors = cellProcessors;
        this.configuration = configuration;
    }

    public void addCell(Cell cell) {
        if (!cell.isEmpty()) {
            this.cells.add(cell);
        }
    }

    public ResultTransformation getTransformationResult() {
        return this.resultTransformation;
    }

    public List getCells() {
        return this.cells;
    }

    public ResultTransformation transform(SheetTransformationController stc, SheetTransformer sheetTransformer, Map beans) {
        CellTransformer cellTransformer = new CellTransformer(this.configuration);
        if (this.cells.isEmpty()) {
            for (int j = 0; j < this.row.getCells().size(); ++j) {
                Cell cell = (Cell)this.row.getCells().get(j);
                this.applyCellProcessors(this.row.getSheet(), cell);
                cellTransformer.transform(cell);
            }
        } else {
            for (int i = 0; i < this.cells.size(); ++i) {
                Cell cell = (Cell)this.cells.get(i);
                this.applyCellProcessors(this.row.getSheet(), cell);
                cellTransformer.transform(cell);
            }
        }
        this.resultTransformation = new ResultTransformation();
        return this.resultTransformation;
    }

    private void applyCellProcessors(Sheet sheet, Cell cell) {
        for (int i = 0; i < this.cellProcessors.size(); ++i) {
            CellProcessor cellProcessor = (CellProcessor)this.cellProcessors.get(i);
            cellProcessor.processCell(cell, sheet.getNamedCells());
        }
    }
}

