/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.transformer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.jxls.controller.SheetTransformationController;
import org.jxls.controller.SheetTransformationControllerImpl;
import org.jxls.controller.WorkbookTransformationController;
import org.jxls.exception.ParsePropertyException;
import org.jxls.formula.ListRange;
import org.jxls.parser.Cell;
import org.jxls.parser.CellParser;
import org.jxls.processor.RowProcessor;
import org.jxls.tag.Block;
import org.jxls.transformation.ResultTransformation;
import org.jxls.transformer.BaseRowTransformer;
import org.jxls.transformer.ChainTransformer;
import org.jxls.transformer.CollectionRowTransformer;
import org.jxls.transformer.Configuration;
import org.jxls.transformer.Row;
import org.jxls.transformer.RowCollection;
import org.jxls.transformer.RowTransformer;
import org.jxls.transformer.Sheet;
import org.jxls.transformer.SimpleRowTransformer;
import org.jxls.transformer.TagRowTransformer;

public class SheetTransformer {
    protected final Log log = LogFactory.getLog(this.getClass());
    private Set groupedCollections = new HashSet();
    private Set fixedSizeCollections = new HashSet();
    private Configuration configuration;
    private List rowProcessors = new ArrayList();
    private List transformers = new ArrayList();
    private List cellProcessors = new ArrayList();

    public SheetTransformer(Set fixedSizeCollections, Set groupedCollections, List rowProcessors, List cellProcessors, Configuration configuration) {
        this.fixedSizeCollections = fixedSizeCollections;
        this.groupedCollections = groupedCollections;
        this.rowProcessors = rowProcessors;
        this.cellProcessors = cellProcessors;
        this.configuration = configuration;
    }

    public SheetTransformer(Set fixedSizeCollections, Set groupedCollections, List rowProcessors, List cellProcessors) {
        this.fixedSizeCollections = fixedSizeCollections;
        this.groupedCollections = groupedCollections;
        this.rowProcessors = rowProcessors;
        this.cellProcessors = cellProcessors;
        this.configuration = new Configuration();
    }

    public void setGroupedCollections(Set groupedCollections) {
        this.groupedCollections = groupedCollections;
    }

    void transformSheet(WorkbookTransformationController workbookTransformationController, Sheet sheet, Map beans) throws ParsePropertyException {
        if (!beans.isEmpty()) {
            SheetTransformationControllerImpl stc = new SheetTransformationControllerImpl(sheet);
            workbookTransformationController.addSheetTransformationController(stc);
            for (int i = sheet.getHssfSheet().getFirstRowNum(); i <= sheet.getHssfSheet().getLastRowNum(); ++i) {
                RowTransformer rowTransformer;
                HSSFRow hssfRow = sheet.getHssfSheet().getRow(i);
                if (hssfRow == null || (rowTransformer = this.parseRow(sheet, hssfRow, beans)) == null) continue;
                Row row = rowTransformer.getRow();
                this.applyRowProcessors(sheet, row);
                ResultTransformation processResult = rowTransformer.transform(stc, this, beans);
                this.transformers.add(rowTransformer);
                i += processResult.getNextRowShift();
            }
            this.groupRows(sheet);
        }
    }

    public ResultTransformation processRows(SheetTransformationController stc, Sheet sheet, int startRow, int endRow, Map beans, Row parentRow) throws ParsePropertyException {
        int origEndRow = endRow;
        int nextRowShiftNumber = 0;
        for (int i = startRow; i <= endRow; ++i) {
            HSSFRow hssfRow = sheet.getHssfSheet().getRow(i);
            if (hssfRow == null) continue;
            ResultTransformation processResult = this.processRow(stc, sheet, hssfRow, beans, parentRow);
            int shiftNumber = processResult.getNextRowShift();
            nextRowShiftNumber += shiftNumber;
            endRow += processResult.getLastRowShift();
            i += shiftNumber;
        }
        return new ResultTransformation(nextRowShiftNumber, endRow - origEndRow);
    }

    ResultTransformation processRow(SheetTransformationController stc, Sheet sheet, HSSFRow hssfRow, Map beans, Row parentRow) {
        return this.processRow(stc, sheet, hssfRow, hssfRow.getFirstCellNum(), hssfRow.getLastCellNum(), beans, parentRow);
    }

    public ResultTransformation processRow(SheetTransformationController stc, Sheet sheet, HSSFRow hssfRow, short startCell, short endCell, Map beans, Row parentRow) {
        List transformers = this.parseCells(sheet, hssfRow, startCell, endCell, beans);
        ChainTransformer chainTransformer = new ChainTransformer(transformers, sheet, this.rowProcessors, parentRow);
        return chainTransformer.transform(stc, this, beans);
    }

    ResultTransformation processCells(Sheet sheet, int startRow, short startCell, int endRow, short endCell, Map beans) {
        if (startRow != endRow) {
            this.log.warn((Object)"Currently we can process cells block only in one row");
        } else {
            HSSFRow hssfRow = sheet.getHssfSheet().getRow(startRow);
            List rowTransformers = this.parseCells(sheet, hssfRow, startCell, endCell, beans);
            if (rowTransformers.size() > 0) {
                RowTransformer rowTransformer = (RowTransformer)rowTransformers.get(0);
                ResultTransformation processResult = rowTransformer.transform(null, this, beans);
            }
        }
        return null;
    }

    private List parseCells(Sheet sheet, HSSFRow hssfRow, short startCell, short endCell, Map beans) {
        ArrayList<BaseRowTransformer> transformers = new ArrayList<BaseRowTransformer>();
        BaseRowTransformer rowTransformer = null;
        Row row = new Row(sheet, hssfRow);
        SimpleRowTransformer simpleRowTransformer = new SimpleRowTransformer(row, this.cellProcessors, this.configuration);
        boolean hasCollections = false;
        boolean hasTags = false;
        for (short j = startCell; j <= endCell; j = (short)(j + 1)) {
            HSSFCell hssfCell = hssfRow.getCell(j);
            CellParser cellParser = new CellParser(hssfCell, row, this.configuration);
            Cell cell = cellParser.parseCell(beans);
            if (cell.getTag() == null) {
                if (cell.getLabel() != null && cell.getLabel().length() > 0) {
                    sheet.addNamedCell(cell.getLabel(), cell);
                }
                RowCollection rowCollection = row.addCell(cell);
                if (cell.getCollectionProperty() != null) {
                    hasCollections = true;
                    if (rowTransformer == null) {
                        rowTransformer = new CollectionRowTransformer(row, this.fixedSizeCollections, this.cellProcessors, this.rowProcessors, this.configuration);
                        transformers.add(rowTransformer);
                    }
                    ((CollectionRowTransformer)rowTransformer).addRowCollection(rowCollection);
                    ListRange listRange = new ListRange(row.getHssfRow().getRowNum(), row.getHssfRow().getRowNum() + rowCollection.getCollectionProperty().getCollection().size() - 1, j);
                    this.addListRange(sheet, cell.getCollectionProperty().getProperty(), listRange);
                    continue;
                }
                if (cell.isEmpty()) continue;
                simpleRowTransformer.addCell(cell);
                continue;
            }
            rowTransformer = new TagRowTransformer(row, cell);
            Block tagBody = cell.getTag().getTagContext().getTagBody();
            j = (short)(j + (tagBody.getNumberOfColumns() - 1));
            transformers.add(rowTransformer);
        }
        if (!hasCollections && simpleRowTransformer.getCells().size() > 0) {
            transformers.add(simpleRowTransformer);
        }
        for (int i = 0; i < row.getCells().size(); ++i) {
            Cell cell = (Cell)row.getCells().get(i);
            if (cell.getTag() != null) continue;
            if (cell.getRowCollection() == null && cell.getCollectionName() != null) {
                RowCollection rowCollection = row.getRowCollectionByCollectionName(cell.getCollectionName());
                if (rowCollection != null) {
                    rowCollection.addCell(cell);
                } else {
                    this.log.warn((Object)("RowCollection with name " + cell.getCollectionName() + " not found"));
                }
            } else if (cell.isEmpty() && cell.getRowCollection() == null && cell.getMergedRegion() == null && row.getRowCollections().size() == 1) {
                ((RowCollection)row.getRowCollections().get(0)).addCell(cell);
            }
            if (!cell.isFormula() || !cell.getFormula().isInline() || cell.getLabel() == null || cell.getLabel().length() <= 0) continue;
            ListRange listRange = new ListRange(row.getHssfRow().getRowNum(), row.getHssfRow().getRowNum() + cell.getRowCollection().getCollectionProperty().getCollection().size() - 1, cell.getHssfCell().getCellNum());
            this.addListRange(sheet, cell.getLabel(), listRange);
        }
        return transformers;
    }

    RowTransformer parseRow(Sheet sheet, HSSFRow hssfRow, Map beans) {
        List transformers = this.parseCells(sheet, hssfRow, hssfRow.getFirstCellNum(), hssfRow.getLastCellNum(), beans);
        if (transformers.size() > 0) {
            return (RowTransformer)transformers.get(0);
        }
        return null;
    }

    private boolean addListRange(Sheet sheet, String rangeName, ListRange range) {
        if (sheet.getListRanges().containsKey(rangeName)) {
            sheet.addListRange(rangeName, range);
            return true;
        }
        sheet.addListRange(rangeName, range);
        return false;
    }

    private void applyRowProcessors(Sheet sheet, Row row) {
        for (int i = 0; i < this.rowProcessors.size(); ++i) {
            RowProcessor rowProcessor = (RowProcessor)this.rowProcessors.get(i);
            rowProcessor.processRow(row, sheet.getNamedCells());
        }
    }

    void groupRows(Sheet sheet) {
        Iterator iterator = this.groupedCollections.iterator();
        while (iterator.hasNext()) {
            String collectionName = (String)iterator.next();
            if (!sheet.getListRanges().containsKey(collectionName)) continue;
            ListRange listRange = (ListRange)sheet.getListRanges().get(collectionName);
            sheet.getHssfSheet().groupRow(listRange.getFirstRowNum(), listRange.getLastRowNum());
        }
    }
}

