/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.transformer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.jxls.formula.Formula;
import org.jxls.formula.ListRange;
import org.jxls.parser.Cell;
import org.jxls.tag.Block;
import org.jxls.tag.Point;
import org.jxls.transformer.Configuration;
import org.jxls.transformer.Workbook;
import org.jxls.util.SheetHelper;

public class Sheet {
    Workbook workbook;
    HSSFWorkbook hssfWorkbook;
    HSSFSheet hssfSheet;
    private Map listRanges = new HashMap();
    private Map namedCells = new HashMap();
    Configuration configuration = new Configuration();

    public Sheet() {
    }

    public Sheet(HSSFWorkbook hssfWorkbook, HSSFSheet hssfSheet, Configuration configuration) {
        this.hssfWorkbook = hssfWorkbook;
        this.hssfSheet = hssfSheet;
        this.configuration = configuration;
    }

    public Sheet(HSSFWorkbook hssfWorkbook, HSSFSheet hssfSheet) {
        this.hssfWorkbook = hssfWorkbook;
        this.hssfSheet = hssfSheet;
    }

    public String getSheetName() {
        for (int i = 0; i < this.hssfWorkbook.getNumberOfSheets(); ++i) {
            HSSFSheet sheet = this.hssfWorkbook.getSheetAt(i);
            if (sheet != this.hssfSheet) continue;
            return this.hssfWorkbook.getSheetName(i);
        }
        return null;
    }

    public HSSFWorkbook getHssfWorkbook() {
        return this.hssfWorkbook;
    }

    public void setHssfWorkbook(HSSFWorkbook hssfWorkbook) {
        this.hssfWorkbook = hssfWorkbook;
    }

    public void setHssfSheet(HSSFSheet hssfSheet) {
        this.hssfSheet = hssfSheet;
    }

    public HSSFSheet getHssfSheet() {
        return this.hssfSheet;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Map getListRanges() {
        return this.listRanges;
    }

    public Map getNamedCells() {
        return this.namedCells;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public void setWorkbook(Workbook workbook) {
        this.workbook = workbook;
    }

    public void addNamedCell(String label, Cell cell) {
        this.namedCells.put(label, cell);
    }

    public void addListRange(String name, ListRange range) {
        this.listRanges.put(name, range);
    }

    public int getMaxColNum() {
        short maxColNum = 0;
        for (int i = this.hssfSheet.getFirstRowNum(); i <= this.hssfSheet.getLastRowNum(); ++i) {
            HSSFRow hssfRow = this.hssfSheet.getRow(i);
            if (hssfRow == null || hssfRow.getLastCellNum() <= maxColNum) continue;
            maxColNum = hssfRow.getLastCellNum();
        }
        return maxColNum;
    }

    public Map getFormulaCellRefsToUpdate(Block block) {
        List formulas = SheetHelper.findFormulas(this);
        HashMap formulaCellRefsToUpdate = new HashMap();
        String transformedSheetName = block.getSheet().getSheetName();
        for (int j = 0; j < formulas.size(); ++j) {
            Formula formula = (Formula)formulas.get(j);
            Set refCells = formula.findRefCells();
            Point key = new Point(formula.getRowNum(), formula.getCellNum().shortValue());
            ArrayList refCellsToUpdate = new ArrayList();
            Iterator iterator = refCells.iterator();
            while (iterator.hasNext()) {
                String refCell = (String)iterator.next();
                if (refCell.indexOf("!") < 0) {
                    if (block.getSheet().getHssfSheet() != this.hssfSheet) continue;
                    this.updateRefCellList(refCellsToUpdate, refCell, block);
                    continue;
                }
                int index = refCell.indexOf("!");
                String sheetName = refCell.substring(0, index);
                if (!sheetName.equalsIgnoreCase(transformedSheetName)) continue;
                this.updateRefCellList(refCellsToUpdate, refCell, block);
            }
            if (refCellsToUpdate.isEmpty()) continue;
            formulaCellRefsToUpdate.put(key, refCellsToUpdate);
        }
        return formulaCellRefsToUpdate;
    }

    private void updateRefCellList(List refCellsToUpdate, String refCell, Block block) {
        Point point = new Point(refCell);
        if (block.contains(point)) {
            refCellsToUpdate.add(refCell);
        }
    }
}

