/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.transformer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jxls.controller.SheetTransformationController;
import org.jxls.exception.ParsePropertyException;
import org.jxls.formula.ListRange;
import org.jxls.parser.Property;
import org.jxls.transformation.ResultTransformation;
import org.jxls.transformer.BaseRowTransformer;
import org.jxls.transformer.Configuration;
import org.jxls.transformer.Row;
import org.jxls.transformer.RowCollection;
import org.jxls.transformer.SheetTransformer;
import org.jxls.transformer.SimpleRowTransformer;
import org.jxls.util.Util;

public class CollectionRowTransformer
extends BaseRowTransformer {
    private Configuration configuration;
    private List rowProcessors = new ArrayList();
    private List cellProcessors = new ArrayList();
    List rowCollections = new ArrayList();
    private ResultTransformation resultTransformation;
    private Set fixedSizeCollections = new HashSet();

    public CollectionRowTransformer(Row row, Set fixedSizeCollections, List cellProcessors, List rowProcessors, Configuration configuration) {
        this.fixedSizeCollections = fixedSizeCollections;
        this.cellProcessors = cellProcessors;
        this.configuration = configuration;
        this.rowProcessors = rowProcessors;
        this.row = row;
    }

    public ResultTransformation getTransformationResult() {
        return this.resultTransformation;
    }

    void addRowCollection(RowCollection rowCollection) {
        this.rowCollections.add(rowCollection);
    }

    public ResultTransformation transform(SheetTransformationController stc, SheetTransformer sheetTransformer, Map beans) {
        try {
            SimpleRowTransformer simpleRowTransformer = new SimpleRowTransformer(this.row, this.cellProcessors, this.configuration);
            simpleRowTransformer.transform(stc, sheetTransformer, beans);
            this.resultTransformation = this.processRowCollections(stc, sheetTransformer, this.row, beans);
            sheetTransformer.groupRows(this.row.getSheet());
        }
        catch (ParsePropertyException e) {
            e.printStackTrace();
            this.resultTransformation = new ResultTransformation(0);
        }
        return this.resultTransformation;
    }

    ResultTransformation processRowCollections(SheetTransformationController sheetTransformationController, SheetTransformer sheetTransformer, Row row, Map beans) throws ParsePropertyException {
        int maxShiftNumber = 0;
        int rowNum = row.getHssfRow().getRowNum();
        HashSet keys = new HashSet(beans.keySet());
        for (int i = 0; i < row.getRowCollections().size(); ++i) {
            RowCollection rowCollection = (RowCollection)row.getRowCollections().get(i);
            if (!rowCollection.getCollectionProperty().getCollection().isEmpty()) {
                Property collectionProperty = rowCollection.getCollectionProperty();
                String collectionItem = this.generateCollectionItem(collectionProperty.getFullCollectionName(), keys);
                rowCollection.setCollectionItemName(collectionItem);
                keys.add(collectionItem);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("----collection-property--------->" + collectionProperty.getCollectionName()));
                }
                ListRange listRange = new ListRange(rowNum, rowNum + collectionProperty.getCollection().size() - 1, 0);
                listRange.setListName(collectionProperty.getCollectionName());
                listRange.setListAlias(rowCollection.getCollectionItemName());
                this.addListRange(row.getSheet(), rowCollection.getCollectionItemName(), listRange);
                this.addListRange(row.getSheet(), collectionProperty.getFullCollectionName(), listRange);
                if (!this.fixedSizeCollections.contains(collectionProperty.getCollectionName())) {
                    Util.prepareCollectionPropertyInRowForDuplication(rowCollection, rowCollection.getCollectionItemName());
                    sheetTransformationController.duplicateRow(rowCollection);
                    continue;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Fixed size collection found: " + collectionProperty.getCollectionName()));
                }
                if (rowCollection.getDependentRowNumber() != 0) {
                    this.log.warn((Object)"Dependent rows for fixed size collections are not supported.");
                }
                Util.prepareCollectionPropertyInRowForContentDuplication(rowCollection);
                Util.duplicateRowCollectionProperty(rowCollection);
                continue;
            }
            Util.removeRowCollectionPropertiesFromRow(rowCollection);
        }
        if (row.getRowCollections().size() > 0) {
            RowCollection rowCollection;
            int i;
            RowCollection maxSizeCollection = row.getMaxSizeCollection();
            int minDependentRowNumber = row.getMinDependentRowNumber();
            int mainShiftNumber = 0;
            for (i = 0; i < row.getRowCollections().size(); ++i) {
                rowCollection = (RowCollection)row.getRowCollections().get(i);
                rowCollection.createIterator(minDependentRowNumber);
            }
            for (int k = 0; k < maxSizeCollection.getCollectionProperty().getCollection().size(); ++k) {
                for (int i2 = 0; i2 < row.getRowCollections().size(); ++i2) {
                    RowCollection rowCollection2 = (RowCollection)row.getRowCollections().get(i2);
                    if (!rowCollection2.hasNextObject()) continue;
                    Object o = rowCollection2.getNextObject();
                    beans.put(rowCollection2.getCollectionItemName(), o);
                }
                ResultTransformation processResult = sheetTransformer.processRows(sheetTransformationController, row.getSheet(), rowNum + (minDependentRowNumber + 1) * k, rowNum + (minDependentRowNumber + 1) * k + minDependentRowNumber, beans, row);
                int shiftNumber = processResult.getNextRowShift();
                mainShiftNumber += shiftNumber + 1;
                rowNum += shiftNumber;
            }
            for (i = 0; i < row.getRowCollections().size(); ++i) {
                rowCollection = (RowCollection)row.getRowCollections().get(i);
                beans.remove(rowCollection.getCollectionItemName());
            }
            if (mainShiftNumber - 1 > maxShiftNumber) {
                maxShiftNumber = mainShiftNumber - 1;
            }
        }
        return new ResultTransformation(maxShiftNumber, maxShiftNumber);
    }

    private String generateCollectionItem(String collectionName, Set keys) {
        String origKey = collectionName.replace('.', '_');
        String key = origKey + "_JxLsC_";
        int index = 0;
        while (keys.contains(key)) {
            key = origKey + index++ + "_JxLsC_";
        }
        return key;
    }
}

