/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.transformer;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jxls.controller.SheetTransformationController;
import org.jxls.processor.RowProcessor;
import org.jxls.tag.Block;
import org.jxls.transformation.ResultTransformation;
import org.jxls.transformer.Row;
import org.jxls.transformer.RowTransformer;
import org.jxls.transformer.Sheet;
import org.jxls.transformer.SheetTransformer;

public class ChainTransformer {
    protected final Log log = LogFactory.getLog(this.getClass());
    List transformers;
    Sheet sheet;
    List rowProcessors;
    Row parentRow;

    public ChainTransformer(List transformers, Sheet sheet, List rowProcessors, Row parentRow) {
        this.transformers = transformers;
        this.sheet = sheet;
        this.rowProcessors = rowProcessors;
        this.parentRow = parentRow;
    }

    public ChainTransformer(List transformers, List rowProcessors, Row parentRow) {
        this.transformers = transformers;
        this.rowProcessors = rowProcessors;
        this.parentRow = parentRow;
    }

    public ChainTransformer(List transformers, List rowProcessors) {
        this.transformers = transformers;
        this.rowProcessors = rowProcessors;
    }

    public ChainTransformer(List transformers) {
        this.transformers = transformers;
    }

    ResultTransformation transform(SheetTransformationController stc, SheetTransformer sheetTransformer, Map beans) {
        ResultTransformation resultTransformation = new ResultTransformation();
        for (int i = 0; i < this.transformers.size(); ++i) {
            RowTransformer rowTransformer = (RowTransformer)this.transformers.get(i);
            Block transformationBlock = rowTransformer.getTransformationBlock();
            transformationBlock = resultTransformation.transformBlock(transformationBlock);
            rowTransformer.setTransformationBlock(transformationBlock);
            this.log.debug((Object)(rowTransformer.getClass().getName() + ", " + rowTransformer.getTransformationBlock()));
            Row row = rowTransformer.getRow();
            row.setParentRow(this.parentRow);
            this.applyRowProcessors(this.sheet, row);
            resultTransformation.add(rowTransformer.transform(stc, sheetTransformer, beans));
        }
        return resultTransformation;
    }

    private void applyRowProcessors(Sheet sheet, Row row) {
        for (int i = 0; i < this.rowProcessors.size(); ++i) {
            RowProcessor rowProcessor = (RowProcessor)this.rowProcessors.get(i);
            rowProcessor.processRow(row, sheet.getNamedCells());
        }
    }
}

