/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.transformer;

import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jxls.formula.Formula;
import org.jxls.parser.Cell;
import org.jxls.parser.Expression;
import org.jxls.transformer.Configuration;

public class CellTransformer {
    protected final Log log = LogFactory.getLog(this.getClass());
    private Configuration configuration;

    public CellTransformer(Configuration configuration) {
        this.configuration = configuration != null ? configuration : new Configuration();
    }

    void transform(Cell cell) {
        try {
            if (cell.getHssfCell() != null && cell.getHssfCell().getCellType() == 1) {
                if (cell.getCollectionProperty() == null) {
                    if (cell.getFormula() == null) {
                        if (cell.getExpressions().size() == 0) {
                            if (cell.getMetaInfo() != null) {
                                cell.getHssfCell().setEncoding((short)1);
                                cell.getHssfCell().setCellValue(cell.getStringCellValue());
                            }
                        } else if (cell.getExpressions().size() == 1) {
                            Object value = ((Expression)cell.getExpressions().get(0)).evaluate();
                            if (value == null) {
                                cell.getHssfCell().setCellValue("");
                            } else if (value instanceof Double) {
                                cell.getHssfCell().setCellValue(((Double)value).doubleValue());
                            } else if (value instanceof BigDecimal) {
                                cell.getHssfCell().setCellValue(((BigDecimal)value).doubleValue());
                            } else if (value instanceof Date) {
                                cell.getHssfCell().setCellValue((Date)value);
                            } else if (value instanceof Integer) {
                                cell.getHssfCell().setCellValue((double)((Integer)value).intValue());
                            } else if (value instanceof Long) {
                                cell.getHssfCell().setCellValue((double)((Long)value).longValue());
                            } else {
                                String fixedValue = value.toString();
                                if (fixedValue != null) {
                                    fixedValue = fixedValue.replaceAll("\r\n", "\n");
                                }
                                cell.getHssfCell().setEncoding((short)1);
                                cell.getHssfCell().setCellValue(fixedValue);
                            }
                        } else if (cell.getExpressions().size() > 1) {
                            String value = "";
                            for (int i = 0; i < cell.getExpressions().size(); ++i) {
                                Expression expr = (Expression)cell.getExpressions().get(i);
                                Object propValue = expr.evaluate();
                                if (propValue == null) continue;
                                value = value + propValue.toString();
                            }
                            cell.getHssfCell().setEncoding((short)1);
                            cell.getHssfCell().setCellValue(value);
                        }
                    } else {
                        CellTransformer.processFormulaCell(cell);
                    }
                } else {
                    String value = "";
                    for (int i = 0; i < cell.getExpressions().size(); ++i) {
                        Expression expr = (Expression)cell.getExpressions().get(i);
                        value = expr.getCollectionProperty() == null ? value + expr.evaluate() : value + this.configuration.getStartExpressionToken() + expr.getExpression() + this.configuration.getEndExpressionToken();
                    }
                    cell.getHssfCell().setEncoding((short)1);
                    cell.getHssfCell().setCellValue(value);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.debug((Object)"Can't parse expression");
        }
    }

    private static void processFormulaCell(Cell cell) {
        Formula formula = cell.getFormula();
        if (formula.isInline()) {
            if (cell.getCollectionName() != null) {
                cell.getHssfCell().setCellValue(cell.getStringCellValue());
            } else {
                String formulaString = formula.getInlineFormula(cell.getRow().getHssfRow().getRowNum() + 1);
                cell.getHssfCell().setCellFormula(formulaString);
            }
        }
    }
}

