/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.transformation;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.util.CellReference;
import org.jxls.tag.Block;
import org.jxls.tag.Point;
import org.jxls.transformation.BlockTransformation;

public class ShiftTransformation
extends BlockTransformation {
    int rowShift;
    int colShift;

    public ShiftTransformation(Block block, int rowShift, int colShift) {
        super(block);
        this.rowShift = rowShift;
        this.colShift = colShift;
    }

    public Block getBlockAfterTransformation() {
        return null;
    }

    public List transformCell(Point p) {
        ArrayList<Point> cells = new ArrayList<Point>();
        if (this.block.contains(p) || this.block.isAbove(p)) {
            cells.add(p.shift(this.rowShift, this.colShift));
        } else {
            cells.add(p);
        }
        return cells;
    }

    public List transformCell(String sheetName, String cell) {
        Point p;
        CellReference cellRef = new CellReference(cell);
        int rowNum = cellRef.getRow();
        short colNum = cellRef.getCol();
        String refSheetName = cellRef.getSheetName();
        ArrayList<String> cells = new ArrayList<String>();
        if ((this.block.getSheet().getSheetName().equalsIgnoreCase(refSheetName) || refSheetName == null && this.block.getSheet().getSheetName().equalsIgnoreCase(sheetName)) && (this.block.contains(p = new Point(rowNum, colNum)) || this.block.isAbove(p))) {
            p = p.shift(this.rowShift, this.colShift);
            cellRef = new CellReference(p.getRow(), (int)p.getCol());
            if (refSheetName != null) {
                cells.add(refSheetName + "!" + cellRef.toString());
            } else {
                cells.add(cellRef.toString());
            }
        }
        return cells;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ShiftTransformation) {
            ShiftTransformation st = (ShiftTransformation)obj;
            return super.equals(obj) && this.rowShift == st.rowShift && this.colShift == st.colShift;
        }
        return false;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + this.rowShift;
        result = 29 * result + this.colShift;
        return result;
    }

    public String toString() {
        return "ShiftTransformation: {" + super.toString() + ", shift=(" + this.rowShift + ", " + this.colShift + ")}";
    }
}

