/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.transformation;

import org.jxls.tag.Block;
import org.jxls.transformation.BaseTransformation;

public class ResultTransformation
extends BaseTransformation {
    int lastRowShift;
    int nextRowShift;
    short nextCellShift;
    short lastCellShift;

    public ResultTransformation() {
    }

    public ResultTransformation(short nextCellShift, short lastCellShift) {
        this.nextCellShift = nextCellShift;
        this.lastCellShift = lastCellShift;
    }

    public ResultTransformation(int nextRowShift) {
        this.nextRowShift = nextRowShift;
    }

    public ResultTransformation(int nextRowShift, int lastRowShift) {
        this.nextRowShift = nextRowShift;
        this.lastRowShift = lastRowShift;
    }

    public ResultTransformation add(ResultTransformation transformation) {
        this.lastRowShift += transformation.getLastRowShift();
        this.nextRowShift += transformation.getNextRowShift();
        this.lastCellShift = (short)(this.lastCellShift + transformation.getLastCellShift());
        this.nextCellShift = (short)(this.nextCellShift + transformation.getNextCellShift());
        return this;
    }

    public Block transformBlock(Block block) {
        if (block != null) {
            block = block.horizontalShift(this.lastCellShift);
            block = block.verticalShift(this.lastRowShift);
        }
        return block;
    }

    public ResultTransformation addNextRowShift(int shift) {
        this.nextRowShift += shift;
        return this;
    }

    public ResultTransformation addRightShift(short shift) {
        this.lastCellShift = (short)(this.lastCellShift + shift);
        return this;
    }

    public short getLastCellShift() {
        return this.lastCellShift;
    }

    public int getLastRowShift() {
        return this.lastRowShift;
    }

    public void setLastRowShift(int lastRowShift) {
        this.lastRowShift = lastRowShift;
    }

    public int getNextRowShift() {
        return this.nextRowShift;
    }

    public void setNextRowShift(int nextRowShift) {
        this.nextRowShift = nextRowShift;
    }

    public short getNextCellShift() {
        return this.nextCellShift;
    }
}

