/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.transformation;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.util.CellReference;
import org.jxls.tag.Block;
import org.jxls.tag.Point;
import org.jxls.transformation.BlockTransformation;

public class DuplicateTransformation
extends BlockTransformation {
    int duplicateNumber;

    public DuplicateTransformation(Block block, int duplicateNumber) {
        super(block);
        this.duplicateNumber = duplicateNumber;
    }

    public Block getBlockAfterTransformation() {
        return null;
    }

    public List transformCell(Point p) {
        ArrayList<Point> cells;
        if (this.block.contains(p)) {
            cells = new ArrayList<Point>();
            Point rp = p;
            for (int i = 0; i < this.duplicateNumber; ++i) {
                rp = rp.shift(this.block.getNumberOfRows(), 0);
                cells.add(rp);
            }
        } else {
            cells = new ArrayList();
            cells.add(p);
        }
        return cells;
    }

    public List transformCell(String sheetName, String cell) {
        Point p;
        CellReference cellRef = new CellReference(cell);
        int rowNum = cellRef.getRow();
        short colNum = cellRef.getCol();
        String refSheetName = cellRef.getSheetName();
        ArrayList<String> cells = new ArrayList<String>();
        if ((this.block.getSheet().getSheetName().equalsIgnoreCase(refSheetName) || refSheetName == null && this.block.getSheet().getSheetName().equalsIgnoreCase(sheetName)) && this.block.contains(p = new Point(rowNum, colNum)) && this.duplicateNumber >= 1) {
            cells.add(p.toString(refSheetName));
            for (int i = 0; i < this.duplicateNumber; ++i) {
                p = p.shift(this.block.getNumberOfRows(), 0);
                cells.add(p.toString(refSheetName));
            }
        }
        return cells;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof DuplicateTransformation) {
            DuplicateTransformation dt = (DuplicateTransformation)obj;
            return super.equals(obj) && dt.duplicateNumber == this.duplicateNumber;
        }
        return false;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + this.duplicateNumber;
        return result;
    }

    public String toString() {
        return "DuplicateTransformation: {" + super.toString() + ", duplicateNumber=" + this.duplicateNumber + "}";
    }
}

