/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.tag;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.jxls.exception.ParsePropertyException;
import org.jxls.tag.BaseTag;
import org.jxls.tag.Block;
import org.jxls.transformation.ResultTransformation;
import org.jxls.transformer.SheetTransformer;

public class OutlineTag
extends BaseTag {
    protected final Log log = LogFactory.getLog(this.getClass());
    public static final String TAG_NAME = "outline";
    private boolean detail;

    public OutlineTag() {
        this.name = TAG_NAME;
    }

    public boolean isDetail() {
        return this.detail;
    }

    public void setDetail(boolean detail) {
        this.detail = detail;
    }

    public ResultTransformation process(SheetTransformer sheetTransformer) {
        this.log.info((Object)"jx:outline tag processing..");
        Block body = this.tagContext.getTagBody();
        if (body.getNumberOfRows() == 1) {
            this.log.warn((Object)"jx:outline for columns is not supported. Ignoring.");
        }
        int shiftNumber = 0;
        ResultTransformation shift = new ResultTransformation(0);
        this.tagContext.getSheetTransformationController().removeBorders(body);
        shiftNumber -= 2;
        try {
            ResultTransformation processResult = sheetTransformer.processRows(this.tagContext.getSheetTransformationController(), this.tagContext.getSheet(), body.getStartRowNum(), body.getEndRowNum(), this.tagContext.getBeans(), null);
            if (body.getStartRowNum() <= body.getEndRowNum() + processResult.getLastRowShift()) {
                this.groupRows(body.getStartRowNum(), body.getEndRowNum() + processResult.getLastRowShift());
            }
            shift.add(processResult);
        }
        catch (ParsePropertyException e) {
            this.log.error((Object)"Can't parse property ", (Throwable)e);
        }
        return shift.add(new ResultTransformation(0, shiftNumber));
    }

    private void groupRows(int startRowNum, int endRowNum) {
        HSSFSheet hssfSheet = this.tagContext.getSheet().getHssfSheet();
        hssfSheet.groupRow(startRowNum, endRowNum);
        hssfSheet.setRowGroupCollapsed(startRowNum, !this.detail);
    }

    private ResultTransformation processOneRowTag(SheetTransformer sheetTransformer) {
        return new ResultTransformation();
    }
}

