/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.tag;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jxls.controller.SheetTransformationControllerImpl;
import org.jxls.exception.ParsePropertyException;
import org.jxls.parser.Expression;
import org.jxls.parser.ExpressionParser;
import org.jxls.tag.BaseTag;
import org.jxls.tag.Block;
import org.jxls.tag.TagContext;
import org.jxls.transformation.ResultTransformation;
import org.jxls.transformer.SheetTransformer;
import org.jxls.util.TagBodyHelper;

public class IfTag
extends BaseTag {
    protected final Log log = LogFactory.getLog(this.getClass());
    public static final String TAG_NAME = "if";
    String test;
    Boolean testResult = null;

    public IfTag() {
        this.name = TAG_NAME;
    }

    public String getTest() {
        return this.test;
    }

    public void setTest(String test) {
        this.test = test;
    }

    public void init(TagContext tagContext) {
        super.init(tagContext);
        ExpressionParser exprParser = new ExpressionParser(this.test, tagContext.getBeans(), tagContext.getSheet().getConfiguration());
        Expression testExpr = exprParser.parse();
        try {
            this.testResult = (Boolean)testExpr.evaluate();
        }
        catch (Exception e) {
            this.log.error((Object)("Can't evaluate test expression: " + this.test), (Throwable)e);
        }
    }

    public ResultTransformation process(SheetTransformer sheetTransformer) {
        this.log.info((Object)("if tag processing. Parameters: test=" + this.test));
        Block body = this.tagContext.getTagBody();
        if (body.getNumberOfRows() == 1) {
            return this.processOneRowTag(sheetTransformer);
        }
        int shiftNumber = 0;
        int numberOfRows = body.getNumberOfRows();
        ResultTransformation shift = new ResultTransformation(0);
        if (this.testResult != null) {
            if (this.testResult.booleanValue()) {
                this.tagContext.getSheetTransformationController().removeBorders(body);
                shiftNumber -= 2;
                try {
                    ResultTransformation processResult = sheetTransformer.processRows(this.tagContext.getSheetTransformationController(), this.tagContext.getSheet(), body.getStartRowNum(), body.getEndRowNum(), this.tagContext.getBeans(), null);
                    shift.add(processResult);
                }
                catch (ParsePropertyException e) {
                    this.log.error((Object)"Can't parse property ", (Throwable)e);
                }
            } else {
                this.tagContext.getSheetTransformationController().removeBodyRows(body);
                shift.add(new ResultTransformation(-1, -body.getNumberOfRows()));
            }
        }
        return shift.add(new ResultTransformation(0, shiftNumber));
    }

    private ResultTransformation processOneRowTag(SheetTransformer sheetTransformer) {
        Block body = this.tagContext.getTagBody();
        TagBodyHelper helper = new TagBodyHelper();
        int shiftNumber = 0;
        SheetTransformationControllerImpl stc = new SheetTransformationControllerImpl(this.tagContext.getSheet());
        stc.removeLeftRightBorders(body);
        Map beans = this.tagContext.getBeans();
        ResultTransformation shift = new ResultTransformation();
        shift.addRightShift((short)(shiftNumber -= 2));
        if (this.testResult != null) {
            if (this.testResult.booleanValue()) {
                ResultTransformation processResult = sheetTransformer.processRow(this.tagContext.getSheetTransformationController(), this.tagContext.getSheet(), this.tagContext.getSheet().getHssfSheet().getRow(body.getStartRowNum()), body.getStartCellNum(), body.getEndCellNum(), beans, null);
                shift.add(processResult);
            } else {
                stc.removeRowCells(this.tagContext.getSheet().getHssfSheet().getRow(body.getStartRowNum()), body.getStartCellNum(), body.getEndCellNum());
                shift.add(new ResultTransformation((short)(-body.getNumberOfColumns()), (short)(-body.getNumberOfColumns())));
            }
        }
        return shift;
    }
}

