/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.tag;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jxls.exception.ParsePropertyException;
import org.jxls.parser.Expression;
import org.jxls.tag.BaseTag;
import org.jxls.tag.Block;
import org.jxls.tag.TagContext;
import org.jxls.transformation.ResultTransformation;
import org.jxls.transformer.Configuration;
import org.jxls.transformer.SheetTransformer;
import org.jxls.util.GroupData;
import org.jxls.util.ReportUtil;
import org.jxls.util.Util;

public class ForEachTag
extends BaseTag {
    protected final Log log = LogFactory.getLog(this.getClass());
    public static final String TAG_NAME = "forEach";
    Configuration configuration = new Configuration();
    static final String GROUP_DATA_KEY = "group";
    private String items;
    private String var;
    private String itemsKey;
    private String collectionPropertyName;
    private String groupBy;
    private Collection itemsCollection;

    public ForEachTag() {
        this.name = TAG_NAME;
    }

    public String getItems() {
        return this.items;
    }

    public void setItems(String items) {
        this.items = items;
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public String getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(String groupBy) {
        this.groupBy = groupBy;
    }

    public void init(TagContext tagContext) {
        super.init(tagContext);
        this.configuration = tagContext.getSheet().getConfiguration();
        this.parseItemsProperty();
        if (tagContext.getBeans().containsKey(this.itemsKey)) {
            Object itemsObject = tagContext.getBeans().get(this.itemsKey);
            this.itemsCollection = this.collectionPropertyName != null ? (Collection)Util.getProperty(itemsObject, this.collectionPropertyName) : (Collection)itemsObject;
        }
    }

    private void parseItemsProperty() {
        if (this.items != null) {
            if (this.items.startsWith(this.configuration.getStartExpressionToken()) && this.items.endsWith(this.configuration.getEndExpressionToken())) {
                this.items = this.items.substring(2, this.items.length() - 1);
                try {
                    Expression expr = new Expression(this.items, this.tagContext.getBeans(), this.configuration);
                    Object obj = expr.evaluate();
                    if (!(obj instanceof Collection)) {
                        throw new RuntimeException("items property in forEach tag must be a collection. " + this.items + " is not ");
                    }
                    this.itemsCollection = (Collection)obj;
                }
                catch (Exception e) {
                    throw new RuntimeException("Can't parse an expression " + this.items, e);
                }
            } else {
                this.log.error((Object)("items attribute should start from " + this.configuration.getStartExpressionToken() + " and end " + "with " + this.configuration.getEndExpressionToken()));
            }
        } else {
            this.log.error((Object)"Collection key is null");
        }
    }

    private void parseItemsPropertyOrig() {
        if (this.items != null) {
            if (this.items.startsWith(this.configuration.getStartExpressionToken()) && this.items.endsWith(this.configuration.getEndExpressionToken())) {
                this.items = this.items.substring(2, this.items.length() - 1);
                int dotCharIndex = this.items.indexOf(".");
                if (dotCharIndex >= 0) {
                    this.itemsKey = this.items.substring(0, dotCharIndex);
                    this.collectionPropertyName = this.items.substring(dotCharIndex + 1);
                } else {
                    this.itemsKey = this.items;
                    this.collectionPropertyName = null;
                }
            } else {
                this.log.error((Object)("items attribute should start from " + this.configuration.getStartExpressionToken() + " and end " + "with " + this.configuration.getEndExpressionToken()));
            }
        } else {
            this.log.error((Object)"Collection key is null");
        }
    }

    public ResultTransformation process(SheetTransformer sheetTransformer) {
        this.log.debug((Object)("forEach tag processing. Attributes: var = " + this.var + ", items=" + this.items));
        this.log.debug((Object)("Current tagContext: " + this.tagContext));
        this.log.debug((Object)("Items Collection: " + this.itemsCollection));
        Block body = this.tagContext.getTagBody();
        if (body.getNumberOfRows() == 1) {
            return this.processOneRowTag(sheetTransformer);
        }
        int shiftNumber = 0;
        this.tagContext.getSheetTransformationController().removeBorders(body);
        shiftNumber -= 2;
        ResultTransformation shift = new ResultTransformation(0);
        if (this.itemsCollection != null) {
            Map beans = this.tagContext.getBeans();
            int k = 0;
            if (this.groupBy == null || this.groupBy.length() == 0) {
                shiftNumber += this.tagContext.getSheetTransformationController().duplicateDown(body, this.itemsCollection.size() - 1);
                Iterator iterator = this.itemsCollection.iterator();
                while (iterator.hasNext()) {
                    Object o = iterator.next();
                    beans.put(this.var, o);
                    try {
                        int startRowNum = body.getStartRowNum() + shift.getLastRowShift() + body.getNumberOfRows() * k++;
                        int endRowNum = startRowNum + body.getNumberOfRows() - 1;
                        ResultTransformation processResult = sheetTransformer.processRows(this.tagContext.getSheetTransformationController(), this.tagContext.getSheet(), startRowNum, endRowNum, beans, null);
                        shift.add(processResult);
                    }
                    catch (ParsePropertyException e) {
                        this.log.error((Object)"Can't parse property ", (Throwable)e);
                    }
                }
            } else {
                try {
                    Collection groupedData = ReportUtil.groupCollectionData(this.itemsCollection, this.groupBy);
                    shiftNumber += this.tagContext.getSheetTransformationController().duplicateDown(body, groupedData.size() - 1);
                    Object savedGroupData = null;
                    if (beans.containsKey(GROUP_DATA_KEY)) {
                        savedGroupData = beans.get(GROUP_DATA_KEY);
                    }
                    Iterator iterator = groupedData.iterator();
                    while (iterator.hasNext()) {
                        GroupData groupData = (GroupData)iterator.next();
                        beans.put(GROUP_DATA_KEY, groupData);
                        try {
                            int startRowNum = body.getStartRowNum() + shift.getLastRowShift() + body.getNumberOfRows() * k++;
                            int endRowNum = startRowNum + body.getNumberOfRows() - 1;
                            ResultTransformation processResult = sheetTransformer.processRows(this.tagContext.getSheetTransformationController(), this.tagContext.getSheet(), startRowNum, endRowNum, beans, null);
                            shift.add(processResult);
                        }
                        catch (ParsePropertyException e) {
                            this.log.error((Object)"Can't parse property ", (Throwable)e);
                        }
                    }
                    beans.remove(GROUP_DATA_KEY);
                    if (savedGroupData != null) {
                        beans.put(GROUP_DATA_KEY, savedGroupData);
                    }
                }
                catch (NoSuchMethodException e) {
                    this.log.error((Object)e, (Throwable)new Exception("Can't group collection data by " + this.groupBy, e));
                }
                catch (IllegalAccessException e) {
                    this.log.error((Object)e, (Throwable)new Exception("Can't group collection data by " + this.groupBy, e));
                }
                catch (InvocationTargetException e) {
                    this.log.error((Object)e, (Throwable)new Exception("Can't group collection data by " + this.groupBy, e));
                }
            }
        } else {
            this.log.warn((Object)(this.items + " collection is null!"));
        }
        shift.add(new ResultTransformation(shiftNumber, shiftNumber));
        return shift;
    }

    private ResultTransformation processOneRowTag(SheetTransformer sheetTransformer) {
        Block body = this.tagContext.getTagBody();
        int shiftNumber = 0;
        this.tagContext.getSheetTransformationController().removeLeftRightBorders(body);
        shiftNumber -= 2;
        shiftNumber += this.tagContext.getSheetTransformationController().duplicateRight(body, this.itemsCollection.size() - 1);
        int k = 0;
        Map beans = this.tagContext.getBeans();
        ResultTransformation shift = new ResultTransformation();
        Iterator iterator = this.itemsCollection.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            beans.put(this.var, o);
            try {
                short startCellNum = (short)(body.getStartCellNum() + shift.getLastCellShift() + body.getNumberOfColumns() * k++);
                short endCellNum = (short)(startCellNum + body.getNumberOfColumns() - 1);
                ResultTransformation processResult = sheetTransformer.processRow(this.tagContext.getSheetTransformationController(), this.tagContext.getSheet(), this.tagContext.getSheet().getHssfSheet().getRow(body.getStartRowNum()), startCellNum, endCellNum, beans, null);
                shift.add(processResult);
            }
            catch (Exception e) {
                this.log.error((Object)"Can't parse property ", (Throwable)e);
            }
        }
        shift.addRightShift((short)shiftNumber);
        return shift;
    }
}

