/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.tag;

import org.jxls.tag.Point;
import org.jxls.transformer.Sheet;

public class Block {
    int startRowNum;
    int endRowNum;
    short startCellNum;
    short endCellNum;
    Sheet sheet;

    public Block(Sheet sheet, int startRowNum, int endRowNum) {
        this.startRowNum = startRowNum;
        this.endRowNum = endRowNum;
        this.startCellNum = (short)-1;
        this.endCellNum = (short)-1;
        this.sheet = sheet;
    }

    public Block(int startRowNum, short startCellNum, int endRowNum, short endCellNum) {
        this.startRowNum = startRowNum;
        this.startCellNum = startCellNum;
        this.endRowNum = endRowNum;
        this.endCellNum = endCellNum;
    }

    public Block horizontalShift(short cellShift) {
        this.startCellNum = (short)(this.startCellNum + cellShift);
        this.endCellNum = (short)(this.endCellNum + cellShift);
        return this;
    }

    public Block verticalShift(int rowShift) {
        this.startRowNum += rowShift;
        this.endRowNum += rowShift;
        return this;
    }

    public short getStartCellNum() {
        return this.startCellNum;
    }

    public void setStartCellNum(short startCellNum) {
        this.startCellNum = startCellNum;
    }

    public short getEndCellNum() {
        return this.endCellNum;
    }

    public void setEndCellNum(short endCellNum) {
        this.endCellNum = endCellNum;
    }

    public int getStartRowNum() {
        return this.startRowNum;
    }

    public void setStartRowNum(int startRowNum) {
        this.startRowNum = startRowNum;
    }

    public int getEndRowNum() {
        return this.endRowNum;
    }

    public void setEndRowNum(int endRowNum) {
        this.endRowNum = endRowNum;
    }

    public int getNumberOfRows() {
        return this.endRowNum - this.startRowNum + 1;
    }

    public int getNumberOfColumns() {
        return this.endCellNum - this.startCellNum + 1;
    }

    public boolean contains(int rowNum, int cellNum) {
        return this.startRowNum <= rowNum && rowNum <= this.endRowNum && (this.startCellNum == -1 && this.endCellNum == -1 || this.startCellNum <= cellNum && cellNum <= this.endCellNum);
    }

    public boolean contains(Point p) {
        return this.startRowNum <= p.getRow() && p.getRow() <= this.endRowNum && (this.startCellNum < 0 || this.endCellNum < 0 || this.startCellNum <= p.getCol() && p.getCol() <= this.endCellNum);
    }

    public boolean isAbove(Point p) {
        return this.endRowNum < p.getRow();
    }

    public boolean isBelow(Point p) {
        return this.startRowNum > p.getRow();
    }

    public boolean isRowBlock() {
        return this.startCellNum < 0 || this.endCellNum < 0 || this.startCellNum > this.endCellNum;
    }

    public boolean isColBlock() {
        return this.startRowNum < 0 || this.endRowNum < 0 || this.startRowNum > this.endRowNum;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public void setSheet(Sheet sheet) {
        this.sheet = sheet;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Block block = (Block)o;
        if (this.endCellNum != block.endCellNum) {
            return false;
        }
        if (this.endRowNum != block.endRowNum) {
            return false;
        }
        if (this.startCellNum != block.startCellNum) {
            return false;
        }
        if (this.startRowNum != block.startRowNum) {
            return false;
        }
        return !(this.sheet != null ? !this.sheet.equals(block.sheet) : block.sheet != null);
    }

    public int hashCode() {
        int result = this.startRowNum;
        result = 29 * result + this.endRowNum;
        result = 29 * result + this.startCellNum;
        result = 29 * result + this.endCellNum;
        result = 29 * result + (this.sheet != null ? this.sheet.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Block (" + this.startRowNum + ", " + this.startCellNum + ", " + this.endRowNum + ", " + this.endCellNum + ")";
    }
}

