/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jxls.parser.ExpressionCollectionParser;
import org.jxls.transformer.Configuration;

public class Property {
    protected final Log log = LogFactory.getLog(this.getClass());
    List propertyTokens = new ArrayList();
    private String beanName;
    private Object bean;
    private String collectionName;
    private Collection collection;
    private String property;
    private Object propertyValue;
    Configuration config;

    public Property(String value) {
        this.propertyValue = value;
    }

    public Property(String property, Map beans, Configuration config) {
        this.property = property;
        this.config = config;
        this.propertyValue = this.getPropertyValue(beans);
    }

    public boolean isConstant() {
        return this.property == null;
    }

    public Object getPropertyValue(Map beans) {
        JexlContext context = JexlHelper.createContext();
        context.setVars(beans);
        ExpressionCollectionParser parser = new ExpressionCollectionParser(context, this.property + ";", this.config.isJexlInnerCollectionsAccess());
        if (parser.getCollection() == null) {
            this.propertyValue = null;
        } else {
            this.collectionName = parser.getCollectionExpression();
            this.collection = parser.getCollection();
            this.beanName = null;
            this.bean = null;
        }
        return this.propertyValue;
    }

    public boolean isCollection() {
        return this.collectionName != null;
    }

    public boolean isNull() {
        return this.getPropertyValue() == null;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public String getProperty() {
        return this.property;
    }

    public Collection getCollection() {
        return this.collection;
    }

    public void setCollection(Collection collection) {
        this.collection = collection;
    }

    public String getFullCollectionName() {
        if (this.beanName == null) {
            return this.collectionName;
        }
        return this.beanName + "." + this.collectionName;
    }

    public String getPropertyNameAfterLastDot() {
        String propertyName = null;
        if (this.property != null) {
            int dotIndex = this.property.lastIndexOf(".");
            propertyName = dotIndex >= 0 ? this.property.substring(dotIndex + 1) : this.property;
        }
        return propertyName;
    }

    public String getPropertyNameAfterFirstDot() {
        String propertyName = null;
        if (this.property != null) {
            int dotIndex = this.property.indexOf(".");
            propertyName = dotIndex >= 0 ? this.property.substring(dotIndex + 1) : this.property;
        }
        return propertyName;
    }

    public String toString() {
        return "Property{property='" + this.property + "'}";
    }

    public Object getPropertyValue() {
        if (this.bean instanceof String) {
            return (String)this.bean;
        }
        return this.propertyValue;
    }

    public void setPropertyValue(Object propertyValue) {
        this.propertyValue = propertyValue;
    }

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object bean) {
        this.bean = bean;
    }
}

