/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.parser;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jxls.parser.Expression;
import org.jxls.transformer.Configuration;

public class ExpressionParser {
    protected final Log log = LogFactory.getLog(this.getClass());
    String expression;
    Map beans;
    Configuration configuration;

    public ExpressionParser(String expression, Map beans, Configuration configuration) {
        this.expression = expression;
        this.beans = beans;
        this.configuration = configuration;
    }

    public Expression parse() {
        Expression expr = null;
        if (this.expression != null) {
            this.expression = this.expression.trim();
            if (this.expression.startsWith(this.configuration.getStartExpressionToken()) && this.expression.endsWith(this.configuration.getEndExpressionToken())) {
                try {
                    expr = new Expression(this.expression.substring(2, this.expression.length() - 1), this.beans, this.configuration);
                }
                catch (Exception e) {
                    this.log.error((Object)("Can't parse expression " + this.expression));
                }
            } else {
                this.log.warn((Object)("Expression should start with " + this.configuration.getStartExpressionToken() + " and end with " + this.configuration.getEndExpressionToken() + " but was " + this.expression));
            }
        }
        return expr;
    }
}

