/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.digester.Digester;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.jxls.exception.ParsePropertyException;
import org.jxls.formula.Formula;
import org.jxls.parser.Cell;
import org.jxls.parser.Expression;
import org.jxls.tag.Block;
import org.jxls.tag.Tag;
import org.jxls.tag.TagContext;
import org.jxls.tag.Taglib;
import org.jxls.transformer.Configuration;
import org.jxls.transformer.Row;
import org.jxls.util.Util;
import org.xml.sax.SAXException;

public class CellParser {
    protected final Log log = LogFactory.getLog(this.getClass());
    private final Cell cell;
    private Configuration configuration;

    public CellParser(HSSFCell hssfCell, Row row, Configuration configuration) {
        this.cell = new Cell(hssfCell, row);
        this.configuration = configuration != null ? configuration : new Configuration();
    }

    public CellParser(Cell cell) {
        this.cell = cell;
    }

    public Cell getCell() {
        return this.cell;
    }

    public Cell parseCell(Map beans) {
        if (this.cell.getHssfCell() != null) {
            try {
                if (this.cell.getHssfCell().getCellType() == 1) {
                    this.cell.setHssfCellValue(this.cell.getHssfCell().getStringCellValue());
                    this.parseCellValue(beans);
                }
            }
            catch (ParsePropertyException e) {
                this.log.error((Object)("Can't get value for property=" + this.cell.getCollectionProperty().getProperty()), (Throwable)e);
                throw new RuntimeException(e);
            }
            this.updateMergedRegions();
        }
        return this.cell;
    }

    public Formula parseCellFormula() {
        if (this.cell.getHssfCell() != null && this.cell.getHssfCell().getCellType() == 1 && this.cell.getHssfCell().getStringCellValue() != null) {
            this.cell.setHssfCellValue(this.cell.getHssfCell().getStringCellValue());
            if (this.cell.getHssfCellValue().startsWith(this.configuration.getStartFormulaToken()) && this.cell.getHssfCellValue().lastIndexOf(this.configuration.getEndFormulaToken()) > 0) {
                this.parseFormula();
            }
        }
        return this.cell.getFormula();
    }

    private void parseFormula() {
        int i = this.cell.getHssfCellValue().lastIndexOf(this.configuration.getEndFormulaToken());
        String expr = this.cell.getHssfCellValue().substring(2, i);
        this.cell.setFormula(new Formula(expr));
        this.cell.getFormula().setRowNum(new Integer(this.cell.getRow().getHssfRow().getRowNum()));
        this.cell.getFormula().setCellNum(new Integer(this.cell.getHssfCell().getCellNum()));
        if (i + 1 < this.cell.getHssfCellValue().length()) {
            String tail = this.cell.getHssfCellValue().substring(i + 1);
            int j = tail.indexOf(this.configuration.getMetaInfoToken());
            if (j >= 0) {
                this.cell.setMetaInfo(tail.substring(j));
                if (j > 0) {
                    this.cell.setLabel(tail.substring(0, j));
                }
                this.cell.setCollectionName(tail.substring(j + 2));
            } else {
                this.cell.setLabel(tail);
            }
        }
        this.cell.setStringCellValue(this.cell.getHssfCellValue().substring(0, i + 1));
    }

    private void parseCellExpression(Map beans) {
        int k;
        this.cell.setCollectionProperty(null);
        String curValue = this.cell.getHssfCellValue();
        int depRowNum = 0;
        int j = curValue.lastIndexOf(this.configuration.getMetaInfoToken());
        if (j >= 0) {
            this.cell.setStringCellValue(this.cell.getHssfCellValue().substring(0, j));
            this.cell.setMetaInfo(this.cell.getHssfCellValue().substring(j + 2));
            String tail = curValue.substring(j + 2);
            k = tail.indexOf(":");
            if (k >= 0) {
                try {
                    depRowNum = Integer.parseInt(tail.substring(k + 1));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                this.cell.setCollectionName(tail.substring(0, k));
            } else {
                this.cell.setCollectionName(tail);
            }
            curValue = curValue.substring(0, j);
        } else {
            this.cell.setStringCellValue(this.cell.getHssfCellValue());
        }
        try {
            while (curValue.length() > 0) {
                int i = curValue.indexOf(this.configuration.getStartExpressionToken());
                if (i >= 0) {
                    k = curValue.indexOf(this.configuration.getEndExpressionToken(), i + 2);
                    if (k >= 0) {
                        Expression expression;
                        String expr = curValue.substring(i + 2, k);
                        if (i > 0) {
                            String before = curValue.substring(0, i);
                            this.cell.getExpressions().add(new Expression(before, this.configuration));
                        }
                        if ((expression = new Expression(expr, beans, this.configuration)).getCollectionProperty() != null) {
                            if (this.cell.getCollectionProperty() == null) {
                                this.cell.setCollectionName(expression.getCollectionProperty().getFullCollectionName());
                                this.cell.setCollectionProperty(expression.getCollectionProperty());
                                this.cell.setDependentRowNumber(depRowNum);
                            } else if (this.log.isInfoEnabled()) {
                                this.log.info((Object)"Only the same collection property in a cell is allowed.");
                            }
                        }
                        this.cell.getExpressions().add(expression);
                        curValue = curValue.substring(k + 1, curValue.length());
                        continue;
                    }
                    this.cell.getExpressions().add(new Expression(curValue, this.configuration));
                    continue;
                }
                if (curValue.length() != this.cell.getHssfCellValue().length()) {
                    this.cell.getExpressions().add(new Expression(curValue, this.configuration));
                }
                curValue = "";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error((Object)"Can't parse expression", (Throwable)e);
        }
    }

    private void parseCellValue(Map beans) throws ParsePropertyException {
        if (this.cell.getHssfCellValue() != null) {
            if (this.cell.getHssfCellValue().startsWith(this.configuration.getStartFormulaToken()) && this.cell.getHssfCellValue().lastIndexOf(this.configuration.getEndFormulaToken()) > 0) {
                this.parseFormula();
            } else if (this.cell.getHssfCellValue().startsWith("<" + this.configuration.getTagPrefix())) {
                String tagName = this.getTagName(this.cell.getHssfCellValue());
                if (tagName != null) {
                    HSSFCell hssfCell = this.findMatchingPairInRow(this.cell.getRow().getHssfRow(), tagName);
                    if (hssfCell != null) {
                        Block tagBody = new Block(this.cell.getRow().getHssfRow().getRowNum(), this.cell.getHssfCell().getCellNum(), this.cell.getRow().getHssfRow().getRowNum(), hssfCell.getCellNum());
                        this.parseTag(tagName, tagBody, beans);
                    } else {
                        HSSFRow hssfRow = this.findMatchingPair(tagName);
                        if (hssfRow != null) {
                            int lastTagBodyRowNum = hssfRow.getRowNum();
                            Block tagBody = new Block(null, this.cell.getRow().getHssfRow().getRowNum(), lastTagBodyRowNum);
                            this.parseTag(tagName, tagBody, beans);
                        } else {
                            this.log.warn((Object)("Can't find matching tag pair for " + this.cell.getHssfCellValue()));
                        }
                    }
                }
            } else {
                this.parseCellExpression(beans);
            }
        }
    }

    private HSSFCell findMatchingPairInRow(HSSFRow hssfRow, String tagName) {
        int count = 0;
        if (hssfRow != null) {
            for (short j = (short)(this.cell.getHssfCell().getCellNum() + 1); j <= hssfRow.getLastCellNum(); j = (short)(j + 1)) {
                HSSFCell hssfCell = hssfRow.getCell(j);
                if (hssfCell == null || hssfCell.getCellType() != 1) continue;
                String cellValue = hssfCell.getStringCellValue();
                if (cellValue.matches("<" + this.configuration.getTagPrefix() + tagName + "\\b.*")) {
                    ++count;
                    continue;
                }
                if (!cellValue.matches("</" + this.configuration.getTagPrefix() + tagName + ">")) continue;
                if (count == 0) {
                    return hssfCell;
                }
                --count;
            }
        }
        return null;
    }

    private String getTagName(String xmlTag) {
        int i;
        int j;
        for (j = i = this.configuration.getTagPrefix().length() + 1; j < xmlTag.length() && Character.isLetterOrDigit(xmlTag.charAt(j)); ++j) {
        }
        if (j == xmlTag.length()) {
            this.log.warn((Object)"can't determine tag name");
            return null;
        }
        return xmlTag.substring(i, j);
    }

    private HSSFRow findMatchingPair(String tagName) {
        HSSFSheet hssfSheet = this.cell.getRow().getSheet().getHssfSheet();
        int count = 0;
        for (int i = this.cell.getRow().getHssfRow().getRowNum() + 1; i <= hssfSheet.getLastRowNum(); ++i) {
            HSSFRow hssfRow = hssfSheet.getRow(i);
            if (hssfRow == null) continue;
            for (short j = hssfRow.getFirstCellNum(); j <= hssfRow.getLastCellNum(); j = (short)(j + 1)) {
                HSSFCell hssfCell = hssfRow.getCell(j);
                if (hssfCell == null || hssfCell.getCellType() != 1) continue;
                String cellValue = hssfCell.getStringCellValue();
                if (cellValue.matches("<" + this.configuration.getTagPrefix() + tagName + "\\b.*")) {
                    ++count;
                    continue;
                }
                if (!cellValue.matches("</" + this.configuration.getTagPrefix() + tagName + ">")) continue;
                if (count == 0) {
                    return hssfRow;
                }
                --count;
            }
        }
        return null;
    }

    private void parseTag(String tagName, Block tagBody, Map beans) {
        Digester digester = new Digester();
        digester.setNamespaceAware(true);
        digester.setRuleNamespaceURI("http://jxls.sourceforge.net/jxls");
        digester.setValidating(false);
        Set tagKeys = Taglib.getTags().keySet();
        Iterator iterator = tagKeys.iterator();
        while (iterator.hasNext()) {
            String tagKey = (String)iterator.next();
            digester.addObjectCreate("jxls/" + tagKey, (String)Taglib.getTags().get(tagKey));
            digester.addSetProperties("jxls/" + tagKey);
        }
        try {
            String xml = "<jx:jxls xmlns:jx=\"http://jxls.sourceforge.net/jxls\">" + this.cell.getHssfCellValue() + "</" + this.configuration.getTagPrefix() + tagName + ">" + "</jx:jxls>";
            String escapedXml = Util.escapeAttributes(xml);
            Tag tag = (Tag)digester.parse((Reader)new StringReader(escapedXml));
            this.cell.setTag(tag);
            TagContext tagContext = new TagContext(this.cell.getRow().getSheet(), tagBody, beans);
            tag.init(tagContext);
        }
        catch (IOException e) {
            this.log.warn((Object)("Can't parse cell tag " + this.cell.getHssfCellValue()), (Throwable)e);
        }
        catch (SAXException e) {
            this.log.warn((Object)("Can't parse cell tag " + this.cell.getHssfCellValue()), (Throwable)e);
        }
    }

    private void updateMergedRegions() {
        this.cell.setMergedRegion(Util.getMergedRegion(this.cell.getRow().getSheet().getHssfSheet(), this.cell.getRow().getHssfRow().getRowNum(), this.cell.getHssfCell().getCellNum()));
    }
}

