/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.formula;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.poi.hssf.util.CellReference;
import org.jxls.formula.Formula;
import org.jxls.formula.FormulaController;
import org.jxls.tag.Point;
import org.jxls.transformation.BlockTransformation;
import org.jxls.transformation.DuplicateTransformation;
import org.jxls.transformer.Sheet;
import org.jxls.transformer.Workbook;
import org.jxls.util.SheetHelper;
import org.jxls.util.Util;

public class FormulaControllerImpl
implements FormulaController {
    protected static String leftReplacementMarker = "{";
    protected static String rightReplacementMarker = "}";
    protected static String regexReplacementMarker = "\\" + leftReplacementMarker + "[(),a-zA-Z0-9_ :*+/.-]+" + "\\" + rightReplacementMarker;
    Workbook workbook;
    protected static final String regexCellCharPart = "[0-9]+";
    protected static final String regexCellDigitPart = "[a-zA-Z]+";
    protected String cellRangeSeparator = ":";

    public static String replaceFormulaPart(String formulaPart, String refCell, String newCell) {
        String replacedFormulaPart = "";
        String[] parts = formulaPart.split(regexReplacementMarker, 2);
        while (parts.length == 2) {
            replacedFormulaPart = replacedFormulaPart + parts[0].replaceAll(refCell, leftReplacementMarker + newCell + rightReplacementMarker);
            int secondPartIndex = parts[1].length() != 0 ? formulaPart.indexOf(parts[1], parts[0].length()) : formulaPart.length();
            replacedFormulaPart = replacedFormulaPart + formulaPart.substring(parts[0].length(), secondPartIndex);
            formulaPart = parts[1];
            parts = formulaPart.split(regexReplacementMarker, 2);
        }
        replacedFormulaPart = replacedFormulaPart + parts[0].replaceAll(refCell, leftReplacementMarker + newCell + rightReplacementMarker);
        return replacedFormulaPart;
    }

    public FormulaControllerImpl(Workbook workbook) {
        this.workbook = workbook;
    }

    public void updateFormulas(BlockTransformation transformation) {
        List sheets = this.workbook.getSheets();
        for (int i = 0; i < sheets.size(); ++i) {
            Sheet sheet = (Sheet)sheets.get(i);
            List formulas = SheetHelper.findFormulas(sheet);
            String sheetName = sheet.getSheetName();
            for (int j = 0; j < formulas.size(); ++j) {
                Formula formula = (Formula)formulas.get(j);
                Set refCells = formula.findRefCells();
                String updatedFormula = formula.getFormula();
                boolean isFormulaUpdated = false;
                Iterator iterator = refCells.iterator();
                while (iterator.hasNext()) {
                    String cellRef = (String)iterator.next();
                    if (transformation instanceof DuplicateTransformation && transformation.getBlock().contains(new Point(cellRef)) && transformation.getBlock().contains(formula.getRowNum(), formula.getCellNum())) continue;
                    List resultCells = transformation.transformCell(sheetName, cellRef);
                    if (resultCells.size() == 1) {
                        String newCell = (String)resultCells.get(0);
                        updatedFormula = FormulaControllerImpl.replaceFormulaPart(updatedFormula, cellRef, newCell);
                        isFormulaUpdated = true;
                        continue;
                    }
                    if (resultCells.size() <= 1) continue;
                    String refSheetName = this.extractRefSheetName(cellRef);
                    String newCell = this.detectCellRange(refSheetName, resultCells);
                    updatedFormula = FormulaControllerImpl.replaceFormulaPart(formula.getFormula(), cellRef, newCell);
                    isFormulaUpdated = true;
                }
                updatedFormula = updatedFormula.replaceAll("\\" + leftReplacementMarker, "");
                updatedFormula = updatedFormula.replaceAll("\\" + rightReplacementMarker, "");
                if (!isFormulaUpdated) continue;
                Util.updateCellValue(sheet.getHssfSheet(), formula.getRowNum(), formula.getCellNum().shortValue(), sheet.getConfiguration().getStartFormulaToken() + updatedFormula + sheet.getConfiguration().getEndFormulaToken());
            }
        }
    }

    String getSheetName(String cell) {
        CellReference cellRef = new CellReference(cell);
        return cellRef.getSheetName();
    }

    private String extractRefSheetName(String refCell) {
        if (refCell != null) {
            if (refCell.indexOf("!") < 0) {
                return null;
            }
            return refCell.substring(0, refCell.indexOf("!"));
        }
        return null;
    }

    private String extractCellName(String refCell) {
        if (refCell != null) {
            if (refCell.indexOf("!") < 0) {
                return refCell;
            }
            return refCell.substring(refCell.indexOf("!") + 1);
        }
        return null;
    }

    String detectCellRange(String refSheetName, List cells) {
        String firstCell;
        this.cutSheetRefFromCells(cells);
        String range = firstCell = (String)cells.get(0);
        if (firstCell != null && firstCell.length() > 0) {
            if (this.isRowRange(cells) || this.isColumnRange(cells)) {
                String lastCell = (String)cells.get(cells.size() - 1);
                range = this.getRefCellName(refSheetName, firstCell) + this.cellRangeSeparator + lastCell.toUpperCase();
            } else {
                range = this.buildCommaSeparatedListOfCells(refSheetName, cells);
            }
        }
        return range;
    }

    private void cutSheetRefFromCells(List cells) {
        for (int i = 0; i < cells.size(); ++i) {
            String cell = (String)cells.get(i);
            cells.set(i, this.extractCellName(cell));
        }
    }

    String buildCommaSeparatedListOfCells(String refSheetName, List cells) {
        String listOfCells = "";
        for (int i = 0; i < cells.size() - 1; ++i) {
            String cell = (String)cells.get(i);
            listOfCells = listOfCells + this.getRefCellName(refSheetName, cell) + ",";
        }
        listOfCells = listOfCells + this.getRefCellName(refSheetName, (String)cells.get(cells.size() - 1));
        return listOfCells;
    }

    String getRefCellName(String refSheetName, String cellName) {
        if (refSheetName == null) {
            return cellName.toUpperCase();
        }
        return refSheetName + "!" + cellName.toUpperCase();
    }

    boolean isColumnRange(List cells) {
        String firstCell = (String)cells.get(0);
        boolean isColumnRange = true;
        if (firstCell != null && firstCell.length() > 0) {
            String firstCellCharPart = firstCell.split(regexCellCharPart)[0];
            String firstCellDigitPart = firstCell.split(regexCellDigitPart)[1];
            int cellNumber = Integer.parseInt(firstCellDigitPart);
            for (int i = 1; i < cells.size() && isColumnRange; ++i) {
                String nextCell = (String)cells.get(i);
                String cellCharPart = nextCell.split(regexCellCharPart)[0];
                String cellDigitPart = nextCell.split(regexCellDigitPart)[1];
                if (firstCellCharPart.equalsIgnoreCase(cellCharPart) && Integer.parseInt(cellDigitPart) == ++cellNumber) continue;
                isColumnRange = false;
            }
        }
        return isColumnRange;
    }

    boolean isRowRange(List cells) {
        String firstCell = (String)cells.get(0);
        boolean isRowRange = true;
        if (firstCell != null && firstCell.length() > 0) {
            String firstCellDigitPart = firstCell.split(regexCellDigitPart)[1];
            CellReference cellRef = new CellReference(firstCell);
            int cellNumber = cellRef.getCol();
            for (int i = 1; i < cells.size() && isRowRange; ++i) {
                String nextCell = (String)cells.get(i);
                String cellDigitPart = nextCell.split(regexCellDigitPart)[1];
                cellRef = new CellReference(nextCell);
                if (firstCellDigitPart.equalsIgnoreCase(cellDigitPart) && cellRef.getCol() == ++cellNumber) continue;
                isRowRange = false;
            }
        }
        return isRowRange;
    }
}

