/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.formula;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jxls.controller.SheetCellFinder;
import org.jxls.formula.ListRange;
import org.jxls.parser.Cell;
import org.jxls.transformer.Sheet;

public class Formula {
    protected final Log log = LogFactory.getLog(this.getClass());
    private String formula;
    private Integer rowNum;
    private Integer cellNum;
    static final String inlineFormulaToken = "#";
    static final String formulaListRangeToken = "@";
    private String adjustedFormula;
    private Sheet sheet;
    private static final String regexCellRef = "([a-zA-Z]+[a-zA-Z0-9]*![a-zA-Z]+[0-9]+|[a-zA-Z]+[0-9]+|'[^?\\\\/:'*]+'![a-zA-Z]+[0-9]+)";
    private static final Pattern regexCellRefPattern = Pattern.compile("([a-zA-Z]+[a-zA-Z0-9]*![a-zA-Z]+[0-9]+|[a-zA-Z]+[0-9]+|'[^?\\\\/:'*]+'![a-zA-Z]+[0-9]+)");

    public Sheet getSheet() {
        return this.sheet;
    }

    public void setSheet(Sheet sheet) {
        this.sheet = sheet;
    }

    public Formula(String formula) {
        this.formula = formula;
    }

    public Formula() {
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public Integer getRowNum() {
        return this.rowNum;
    }

    public void setRowNum(Integer rowNum) {
        this.rowNum = rowNum;
    }

    public Integer getCellNum() {
        return this.cellNum;
    }

    public void setCellNum(Integer cellNum) {
        this.cellNum = cellNum;
    }

    public boolean isInline() {
        return this.formula.indexOf(inlineFormulaToken) >= 0;
    }

    public String getInlineFormula(int n) {
        if (this.isInline()) {
            return this.formula.replaceAll(inlineFormulaToken, Integer.toString(n));
        }
        return this.formula;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getAppliedFormula(Map listRanges, Map namedCells) {
        String codedFormula = this.formula;
        String appliedFormula = "";
        String delimiter = formulaListRangeToken;
        int index = codedFormula.indexOf(delimiter);
        boolean isExpression = false;
        while (index >= 0) {
            String token = codedFormula.substring(0, index);
            if (isExpression) {
                if (listRanges.containsKey(token)) {
                    appliedFormula = appliedFormula + ((ListRange)listRanges.get(token)).toExcelCellRange();
                } else {
                    if (!namedCells.containsKey(token)) {
                        this.log.warn((Object)("can't find list range or named cell for " + token));
                        return null;
                    }
                    appliedFormula = appliedFormula + ((Cell)namedCells.get(token)).toCellName();
                }
            } else {
                appliedFormula = appliedFormula + token;
            }
            codedFormula = codedFormula.substring(index + 1);
            index = codedFormula.indexOf(delimiter);
            isExpression = !isExpression;
        }
        return appliedFormula + codedFormula;
    }

    String adjust(SheetCellFinder cellFinder) {
        return this.formula;
    }

    public Set findRefCells() {
        HashSet<String> refCells = new HashSet<String>();
        Matcher refCellMatcher = regexCellRefPattern.matcher(this.formula);
        while (refCellMatcher.find()) {
            refCells.add(refCellMatcher.group());
        }
        return refCells;
    }

    public String toString() {
        return "Formula{formula='" + this.formula + "'" + ", rowNum=" + this.rowNum + ", cellNum=" + this.cellNum + "}";
    }

    public boolean containsListRanges() {
        return this.formula.indexOf(formulaListRangeToken) >= 0;
    }
}

