/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.formula;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.util.CellReference;
import org.jxls.formula.Formula;
import org.jxls.formula.FormulaResolver;
import org.jxls.formula.ListRange;
import org.jxls.parser.Cell;
import org.jxls.transformer.Sheet;

public abstract class BaseFormulaResolver
implements FormulaResolver {
    protected static final String regexCellRef = "[a-zA-Z]+[0-9]+";
    protected static final Pattern regexCellRefPattern = Pattern.compile("[a-zA-Z]+[0-9]+");
    protected static final String regexCellCharPart = "[0-9]+";
    protected static final String regexCellDigitPart = "[a-zA-Z]+";
    protected String cellRangeSeparator = ":";
    protected static String formulaListRangeToken = "@";
    protected final Log log = LogFactory.getLog(this.getClass());

    Set findRefCells(String formulaString) {
        HashSet<String> refCells = new HashSet<String>();
        Matcher refCellMatcher = regexCellRefPattern.matcher(formulaString);
        while (refCellMatcher.find()) {
            refCells.add(refCellMatcher.group());
        }
        return refCells;
    }

    String buildCommaSeparatedListOfCells(String refSheetName, List cells) {
        String listOfCells = "";
        for (int i = 0; i < cells.size() - 1; ++i) {
            String cell = (String)cells.get(i);
            listOfCells = listOfCells + this.getRefCellName(refSheetName, cell) + ",";
        }
        listOfCells = listOfCells + this.getRefCellName(refSheetName, (String)cells.get(cells.size() - 1));
        return listOfCells;
    }

    String detectCellRange(String refSheetName, List cells) {
        String firstCell;
        String range = firstCell = (String)cells.get(0);
        if (firstCell != null && firstCell.length() > 0) {
            if (this.isRowRange(cells) || this.isColumnRange(cells)) {
                String lastCell = (String)cells.get(cells.size() - 1);
                range = this.getRefCellName(refSheetName, firstCell) + this.cellRangeSeparator + lastCell.toUpperCase();
            } else {
                range = this.buildCommaSeparatedListOfCells(refSheetName, cells);
            }
        }
        return range;
    }

    String getRefCellName(String refSheetName, String cellName) {
        if (refSheetName == null) {
            return cellName.toUpperCase();
        }
        return refSheetName + "!" + cellName.toUpperCase();
    }

    boolean isColumnRange(List cells) {
        String firstCell = (String)cells.get(0);
        boolean isColumnRange = true;
        if (firstCell != null && firstCell.length() > 0) {
            String firstCellCharPart = firstCell.split(regexCellCharPart)[0];
            String firstCellDigitPart = firstCell.split(regexCellDigitPart)[1];
            int cellNumber = Integer.parseInt(firstCellDigitPart);
            for (int i = 1; i < cells.size() && isColumnRange; ++i) {
                String nextCell = (String)cells.get(i);
                String cellCharPart = nextCell.split(regexCellCharPart)[0];
                String cellDigitPart = nextCell.split(regexCellDigitPart)[1];
                if (firstCellCharPart.equalsIgnoreCase(cellCharPart) && Integer.parseInt(cellDigitPart) == ++cellNumber) continue;
                isColumnRange = false;
            }
        }
        return isColumnRange;
    }

    boolean isRowRange(List cells) {
        String firstCell = (String)cells.get(0);
        boolean isRowRange = true;
        if (firstCell != null && firstCell.length() > 0) {
            String firstCellDigitPart = firstCell.split(regexCellDigitPart)[1];
            CellReference cellRef = new CellReference(firstCell);
            int cellNumber = cellRef.getCol();
            for (int i = 1; i < cells.size() && isRowRange; ++i) {
                String nextCell = (String)cells.get(i);
                String cellDigitPart = nextCell.split(regexCellDigitPart)[1];
                cellRef = new CellReference(nextCell);
                if (firstCellDigitPart.equalsIgnoreCase(cellDigitPart) && cellRef.getCol() == ++cellNumber) continue;
                isRowRange = false;
            }
        }
        return isRowRange;
    }

    /*
     * Enabled aggressive block sorting
     */
    String replaceListRanges(Formula formula) {
        String codedFormula = formula.getFormula();
        Sheet sheet = formula.getSheet();
        String appliedFormula = "";
        String delimiter = formulaListRangeToken;
        int index = codedFormula.indexOf(delimiter);
        boolean isExpression = false;
        while (index >= 0) {
            String token = codedFormula.substring(0, index);
            if (isExpression) {
                if (sheet.getListRanges().containsKey(token)) {
                    appliedFormula = appliedFormula + ((ListRange)sheet.getListRanges().get(token)).toExcelCellRange();
                } else {
                    if (!sheet.getNamedCells().containsKey(token)) {
                        this.log.warn((Object)("can't find list range or named cell for " + token));
                        return null;
                    }
                    appliedFormula = appliedFormula + ((Cell)sheet.getNamedCells().get(token)).toCellName();
                }
            } else {
                appliedFormula = appliedFormula + token;
            }
            codedFormula = codedFormula.substring(index + 1);
            index = codedFormula.indexOf(delimiter);
            isExpression = !isExpression;
        }
        return appliedFormula + codedFormula;
    }

    public static String getFormulaListRangeToken() {
        return formulaListRangeToken;
    }

    public static void setFormulaListRangeToken(String formulaListRangeToken) {
        BaseFormulaResolver.formulaListRangeToken = formulaListRangeToken;
    }
}

