/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hssf.util.CellReference;
import org.jxls.controller.MatrixCell;
import org.jxls.tag.Block;
import org.jxls.tag.Point;
import org.jxls.transformer.RowCollection;

public class TransformationMatrix {
    List matrix;
    Map cells = new HashMap();
    Map cellsMapping = new HashMap();
    Map duplicatedFormulaCellsMapping = new HashMap();
    Map duplicatedFormulaCells = new HashMap();
    boolean isCellMappingsReady;

    public TransformationMatrix(int rowNum, int colNum) {
        this.init(rowNum, colNum);
    }

    public int getRowCount() {
        return this.matrix.size();
    }

    public int getColCount() {
        return ((List)this.matrix.get(0)).size();
    }

    public void buildCellMappings() {
        Set sourceCells = this.cells.keySet();
        Iterator iterator = sourceCells.iterator();
        while (iterator.hasNext()) {
            MatrixCell cell = (MatrixCell)iterator.next();
            Object mappedObject = this.cells.get(cell);
            this.cellsMapping.put(cell, this.findObjectCells(mappedObject));
        }
        this.isCellMappingsReady = true;
    }

    public List findMappedCells(int rowNum, int colNum, boolean useBuiltCellMappings) {
        MatrixCell cell = new MatrixCell(rowNum, colNum);
        if (useBuiltCellMappings) {
            if (!this.isCellMappingsReady) {
                this.buildCellMappings();
            }
            return (List)this.cellsMapping.get(cell);
        }
        return this.findMappedCells(rowNum, colNum);
    }

    public List findMappedCells(int rowNum, int colNum) {
        List mappedCells = new ArrayList();
        MatrixCell cell = new MatrixCell(rowNum, colNum);
        Object mappedObject = this.cells.get(cell);
        if (mappedObject != null) {
            mappedCells = this.findObjectCells(mappedObject);
        }
        return mappedCells;
    }

    private List findObjectCells(Object obj) {
        ArrayList<MatrixCell> cells = new ArrayList<MatrixCell>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            List row = (List)this.matrix.get(i);
            for (int j = 0; j < row.size(); ++j) {
                Object item = row.get(j);
                if (item != obj) continue;
                cells.add(new MatrixCell(i, j));
            }
        }
        return cells;
    }

    public void init(int rowNum, int colNum) {
        int i;
        int dim = rowNum * colNum;
        this.matrix = new ArrayList(dim);
        this.matrix.addAll(Collections.nCopies(rowNum, null));
        for (i = 0; i < rowNum; ++i) {
            this.matrix.set(i, new ArrayList(dim));
        }
        for (i = 0; i < rowNum; ++i) {
            List row = (List)this.matrix.get(i);
            row.addAll(Collections.nCopies(colNum, null));
            for (int j = 0; j < colNum; ++j) {
                Object obj = new Object();
                row.set(j, obj);
                this.cells.put(new MatrixCell(i, j), obj);
            }
        }
    }

    public void shift(int startRowNum, int startColNum, int endColNum, int n) {
        block4: {
            block3: {
                if (n >= 0) break block3;
                for (int i = startRowNum; i < this.getRowCount(); ++i) {
                    List srcRow = (List)this.matrix.get(i);
                    List destRow = (List)this.matrix.get(i + n);
                    this.copyRange(destRow, srcRow, startColNum, endColNum);
                    Collections.fill(srcRow.subList(startColNum, endColNum + 1), new Object());
                }
                break block4;
            }
            if (n <= 0) break block4;
            int destRowNum = startRowNum + n;
            this.matrix.addAll(Collections.nCopies(n, new ArrayList()));
            for (int i = this.getRowCount() - 1; i >= destRowNum; --i) {
                List srcRow = (List)this.matrix.get(i - n);
                ArrayList<Object> destRow = (ArrayList<Object>)this.matrix.get(i);
                if (destRow.size() < srcRow.size()) {
                    destRow = new ArrayList<Object>();
                    destRow.addAll(Collections.nCopies(this.getColCount(), new Object()));
                }
                this.copyRange(destRow, srcRow, startColNum, endColNum);
                this.matrix.set(i, destRow);
                Collections.fill(srcRow.subList(startColNum, endColNum + 1), new Object());
            }
        }
    }

    public void shiftColumns(int startRowNum, int endRowNum, int startColNum, int n) {
        block3: {
            block2: {
                if (n >= 0) break block2;
                for (int i = startRowNum; i <= endRowNum; ++i) {
                    List row = (List)this.matrix.get(i);
                    ArrayList newRow = new ArrayList();
                    newRow.addAll(row.subList(0, startColNum + n));
                    newRow.addAll(row.subList(startColNum, row.size()));
                    this.matrix.set(i, newRow);
                }
                break block3;
            }
            if (n <= 0) break block3;
            for (int i = startRowNum; i <= endRowNum; ++i) {
                List row = (List)this.matrix.get(i);
                row.addAll(startColNum, Collections.nCopies(n, new Object()));
            }
        }
    }

    private void copyRange(List destRow, List srcRow, int startColNum, int endColNum) {
        Collections.copy(destRow.subList(startColNum, endColNum + 1), srcRow.subList(startColNum, endColNum + 1));
    }

    public void duplicateRows(int startRowNum, int endRowNum, int n) {
        int numberOfRows = endRowNum - startRowNum + 1;
        int shiftNumber = numberOfRows * n;
        this.matrix.addAll(endRowNum + 1, Collections.nCopies(shiftNumber, new Object()));
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < numberOfRows; ++j) {
                List srcRow = (List)this.matrix.get(startRowNum + j);
                ArrayList destRow = new ArrayList();
                destRow.addAll(srcRow);
                this.matrix.set(endRowNum + i * numberOfRows + j + 1, destRow);
            }
        }
    }

    public void duplicateRows(int startRowNum, int endRowNum, int n, Map formulaCellsToUpdate) {
        int numberOfRows = endRowNum - startRowNum + 1;
        int shiftNumber = numberOfRows * n;
        this.matrix.addAll(endRowNum + 1, Collections.nCopies(shiftNumber, new Object()));
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < numberOfRows; ++j) {
                List srcRow = (List)this.matrix.get(startRowNum + j);
                ArrayList destRow = new ArrayList();
                destRow.addAll(srcRow);
                this.matrix.set(endRowNum + i * numberOfRows + j + 1, destRow);
            }
            Iterator iterator = formulaCellsToUpdate.keySet().iterator();
            while (iterator.hasNext()) {
                Point point = (Point)iterator.next();
                this.updateFormulaCells(numberOfRows * (i + 1), (List)formulaCellsToUpdate.get(point));
            }
        }
    }

    private void updateFormulaCells(int shiftNumber, List refCellsToUpdate) {
        for (int i = 0; i < refCellsToUpdate.size(); ++i) {
            String refCell = (String)refCellsToUpdate.get(i);
            CellReference cellReference = new CellReference(refCell);
            int rowNum = cellReference.getRow();
            short colNum = cellReference.getCol();
            MatrixCell matrixCell = new MatrixCell(rowNum += shiftNumber, colNum);
            if (this.cells.containsKey(matrixCell)) continue;
            Object obj = new Object();
            this.set(rowNum, colNum, obj);
            this.cells.put(matrixCell, obj);
        }
    }

    public void duplicate(int startRowNum, int endRowNum, int startColNum, int endColNum, int n, boolean shiftRows) {
        int numberOfRows = endRowNum - startRowNum + 1;
        if (shiftRows) {
            this.shift(endRowNum + 1, startColNum, endColNum, numberOfRows * n);
        }
        for (int i = 0; i < n; ++i) {
            int destRowNum = endRowNum + 1 + numberOfRows * i;
            int j = startRowNum;
            while (j <= endRowNum) {
                List<Object> destRow;
                List srcRow = (List)this.matrix.get(j);
                if (destRowNum >= this.matrix.size()) {
                    destRow = new ArrayList<Object>();
                    destRow.addAll(Collections.nCopies(srcRow.size(), new Object()));
                    this.matrix.add(destRow);
                }
                if ((destRow = (List)this.matrix.get(destRowNum)) != null && destRow.isEmpty()) {
                    destRow.addAll(Collections.nCopies(srcRow.size(), new Object()));
                }
                this.copyRange(destRow, srcRow, startColNum, endColNum);
                ++j;
                ++destRowNum;
            }
        }
    }

    public void shiftRows(int startRowNum, int n) {
        if (n < 0) {
            ArrayList newMatrix = new ArrayList();
            newMatrix.addAll(this.matrix.subList(0, startRowNum + n));
            newMatrix.addAll(this.matrix.subList(startRowNum, this.matrix.size()));
            this.matrix = newMatrix;
        } else if (n > 0) {
            this.matrix.addAll(startRowNum, Collections.nCopies(n, null));
            for (int i = startRowNum; i < startRowNum + n; ++i) {
                ArrayList<Object> newRow = new ArrayList<Object>();
                newRow.addAll(Collections.nCopies(this.getColCount(), new Object()));
                this.matrix.set(i, newRow);
            }
        }
    }

    public Object get(int i, int j) {
        return ((List)this.matrix.get(i)).get(j);
    }

    public void set(int i, int j, Object obj) {
        List row = (List)this.matrix.get(i);
        row.set(j, obj);
    }

    void removeRow(int i) {
        this.matrix.remove(i);
    }

    public void removeBorders(int startRowNum, int endRowNum, int startColNum, int endColNum) {
        this.shift(startRowNum + 1, startColNum, endColNum, -1);
        this.shift(endRowNum, startColNum, endColNum, -1);
        this.shiftColumns(startRowNum, endRowNum - 2, startColNum + 1, -1);
        this.shiftColumns(startRowNum, endRowNum - 2, endColNum, -1);
    }

    public void removeBlockRows(Block block) {
    }

    public void duplicateRow(RowCollection rowCollection) {
    }

    public void setRow(int i, List newRow) {
        ArrayList<Object> row = new ArrayList<Object>();
        row.addAll(Collections.nCopies(newRow.size(), null));
        Collections.copy(row, newRow);
        this.matrix.set(i, row);
    }

    public void clearRow(int rowNum, int startColNum, int endColNum) {
        List row = (List)this.matrix.get(rowNum);
        for (int i = startColNum; i <= endColNum; ++i) {
            row.set(i, new Object());
        }
    }

    public void removeLeftRightBorders(int startRowNum, int endRowNum, int startColNum, int endColNum) {
        for (int i = startRowNum; i <= endRowNum; ++i) {
            List row = (List)this.matrix.get(i);
            row.remove(startColNum);
            row.remove(endColNum);
        }
    }

    public void duplicateRight(int startRowNum, int endRowNum, int startColNum, int endColNum, int n) {
        int numberOfColumns = endColNum - startColNum + 1;
        int shiftNumber = numberOfColumns * n;
        for (int i = startRowNum; i <= endRowNum; ++i) {
            List row = (List)this.matrix.get(i);
            row.addAll(endColNum + 1, Collections.nCopies(shiftNumber, new Object()));
            for (int j = 0; j < n; ++j) {
                for (int k = startColNum; k <= endColNum; ++k) {
                    row.set(endColNum + numberOfColumns * j + k - startColNum + 1, row.get(k));
                }
            }
        }
    }

    public Object clone() {
        TransformationMatrix newMatrix = new TransformationMatrix(this.getRowCount(), this.getColCount());
        for (int i = 0; i < this.getRowCount(); ++i) {
            newMatrix.setRow(i, (List)this.matrix.get(i));
        }
        return newMatrix;
    }
}

