/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.jxls.controller.SheetTransformationController;
import org.jxls.formula.Formula;
import org.jxls.formula.FormulaController;
import org.jxls.formula.FormulaControllerImpl;
import org.jxls.parser.Cell;
import org.jxls.tag.Block;
import org.jxls.tag.Point;
import org.jxls.transformation.DuplicateTransformation;
import org.jxls.transformation.RemoveTransformation;
import org.jxls.transformation.ShiftTransformation;
import org.jxls.transformer.RowCollection;
import org.jxls.transformer.Sheet;
import org.jxls.util.SheetHelper;
import org.jxls.util.TagBodyHelper;
import org.jxls.util.Util;

public class SheetTransformationControllerImpl
implements SheetTransformationController {
    List transformations = new ArrayList();
    Sheet sheet;
    TagBodyHelper helper;
    FormulaController formulaController;

    public SheetTransformationControllerImpl(Sheet sheet) {
        this.sheet = sheet;
        this.helper = new TagBodyHelper();
        this.formulaController = new FormulaControllerImpl(sheet.getWorkbook());
    }

    public int duplicateDown(Block block, int n) {
        if (n > 0) {
            ShiftTransformation shiftTransformation = new ShiftTransformation(new Block(this.sheet, block.getEndRowNum() + 1, Integer.MAX_VALUE), n * block.getNumberOfRows(), 0);
            this.transformations.add(shiftTransformation);
            if (block.getSheet() == null) {
                block.setSheet(this.sheet);
            }
            DuplicateTransformation duplicateTransformation = new DuplicateTransformation(block, n);
            this.transformations.add(duplicateTransformation);
            Map formulaRefCellUpdates = this.findFormulaRefCellsToUpdate(block);
            this.formulaController.updateFormulas(shiftTransformation);
            this.formulaController.updateFormulas(duplicateTransformation);
            return TagBodyHelper.duplicateDown(this.sheet.getHssfSheet(), block, n, formulaRefCellUpdates);
        }
        return 0;
    }

    private Map findFormulaRefCellsToUpdate(Block block) {
        HashMap formulaCellRefUpdates = new HashMap();
        List formulas = SheetHelper.findFormulas(this.sheet, block);
        for (int i = 0; i < formulas.size(); ++i) {
            Formula formula = (Formula)formulas.get(i);
            Set refCells = formula.findRefCells();
            Point key = new Point(formula.getRowNum(), formula.getCellNum().shortValue());
            ArrayList<String> refCellsToUpdate = new ArrayList<String>();
            Iterator iterator = refCells.iterator();
            while (iterator.hasNext()) {
                String refCell = (String)iterator.next();
                if (refCell.indexOf("!") >= 0) continue;
                Point point = new Point(refCell);
                if (block.contains(point)) {
                    refCellsToUpdate.add(refCell);
                }
                if (refCellsToUpdate.isEmpty()) continue;
                formulaCellRefUpdates.put(key, refCellsToUpdate);
            }
        }
        return formulaCellRefUpdates;
    }

    public int duplicateRight(Block block, int n) {
        if (n > 0) {
            return TagBodyHelper.duplicateRight(this.sheet.getHssfSheet(), block, n);
        }
        return 0;
    }

    public void removeBorders(Block block) {
        this.transformations.add(new RemoveTransformation(new Block(this.sheet, block.getStartRowNum(), block.getStartRowNum())));
        ShiftTransformation shiftTransformation1 = new ShiftTransformation(new Block(this.sheet, block.getStartRowNum() + 1, Integer.MAX_VALUE), -1, 0);
        this.transformations.add(shiftTransformation1);
        this.transformations.add(new RemoveTransformation(new Block(this.sheet, block.getEndRowNum() - 1, block.getEndRowNum() - 1)));
        ShiftTransformation shiftTransformation2 = new ShiftTransformation(new Block(this.sheet, block.getEndRowNum(), Integer.MAX_VALUE), -1, 0);
        this.transformations.add(shiftTransformation2);
        this.formulaController.updateFormulas(shiftTransformation1);
        this.formulaController.updateFormulas(shiftTransformation2);
        TagBodyHelper.removeBorders(this.sheet.getHssfSheet(), block);
    }

    public void removeLeftRightBorders(Block block) {
        TagBodyHelper.removeLeftRightBorders(this.sheet.getHssfSheet(), block);
    }

    public void removeRowCells(HSSFRow row, short startCellNum, short endCellNum) {
        TagBodyHelper.removeRowCells(this.sheet.getHssfSheet(), row, startCellNum, endCellNum);
    }

    public void removeBodyRows(Block block) {
        this.transformations.add(new RemoveTransformation(block));
        ShiftTransformation shiftTransformation = new ShiftTransformation(new Block(this.sheet, block.getEndRowNum() + 1, Integer.MAX_VALUE), -block.getNumberOfRows(), 0);
        this.transformations.add(shiftTransformation);
        this.formulaController.updateFormulas(shiftTransformation);
        TagBodyHelper.removeBodyRows(this.sheet.getHssfSheet(), block);
    }

    public void duplicateRow(RowCollection rowCollection) {
        int startRowNum = rowCollection.getParentRow().getHssfRow().getRowNum();
        int endRowNum = startRowNum + rowCollection.getDependentRowNumber();
        ShiftTransformation shiftTransformation = new ShiftTransformation(new Block(this.sheet, endRowNum + 1, Integer.MAX_VALUE), rowCollection.getCollectionProperty().getCollection().size() - 1, 0);
        this.transformations.add(shiftTransformation);
        DuplicateTransformation duplicateTransformation = new DuplicateTransformation(new Block(this.sheet, startRowNum, endRowNum), rowCollection.getCollectionProperty().getCollection().size() - 1);
        this.transformations.add(duplicateTransformation);
        List cells = rowCollection.getRowCollectionCells();
        for (int i = 0; i < cells.size(); ++i) {
            Cell cell = (Cell)cells.get(i);
            if (cell != null && cell.getHssfCell() == null) continue;
        }
        this.formulaController.updateFormulas(shiftTransformation);
        this.formulaController.updateFormulas(duplicateTransformation);
        Util.duplicateRow(rowCollection);
    }

    public List getTransformations() {
        return this.transformations;
    }

    public Sheet getSheet() {
        return this.sheet;
    }
}

