/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.controller;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.util.CellReference;
import org.jxls.controller.MatrixCell;
import org.jxls.controller.SheetCellFinder;
import org.jxls.controller.TransformationMatrix;

public class SheetCellFinderImpl
implements SheetCellFinder {
    TransformationMatrix transformationMatrix;

    public SheetCellFinderImpl(TransformationMatrix transformationMatrix) {
        this.transformationMatrix = transformationMatrix;
    }

    public List findCell(String cellName) {
        CellReference cellReference = new CellReference(cellName);
        short colNum = cellReference.getCol();
        int rowNum = cellReference.getRow();
        List matrixCells = this.findCell(rowNum, colNum);
        return this.convertToCellNames(matrixCells);
    }

    public List findCell(int rowNum, int colNum) {
        List matrixCells = this.transformationMatrix.findMappedCells(rowNum, colNum);
        return this.convertToCellNames(matrixCells);
    }

    private List convertToCellNames(List matrixCells) {
        ArrayList<String> stringCells = new ArrayList<String>();
        for (int i = 0; i < matrixCells.size(); ++i) {
            MatrixCell cell = (MatrixCell)matrixCells.get(i);
            stringCells.add(new CellReference(cell.getRowNum(), cell.getColNum()).toString());
        }
        return stringCells;
    }
}

