/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.time;

public class StopWatch {
    private static final int MILLIS_IN_HOUR = 3600000;
    private static final int MILLIS_IN_MINUTE = 60000;
    private long startTime = -1L;
    private long stopTime = -1L;

    public void start() {
        this.stopTime = -1L;
        this.startTime = System.currentTimeMillis();
    }

    public void stop() {
        this.stopTime = System.currentTimeMillis();
    }

    public void reset() {
        this.startTime = -1L;
        this.stopTime = -1L;
    }

    public void split() {
        this.stopTime = System.currentTimeMillis();
    }

    public void unsplit() {
        this.stopTime = -1L;
    }

    public void suspend() {
        this.stopTime = System.currentTimeMillis();
    }

    public void resume() {
        this.startTime += System.currentTimeMillis() - this.stopTime;
        this.stopTime = -1L;
    }

    public long getTime() {
        if (this.stopTime == -1L) {
            if (this.startTime == -1L) {
                return 0L;
            }
            return System.currentTimeMillis() - this.startTime;
        }
        return this.stopTime - this.startTime;
    }

    public String toString() {
        return StopWatch.toString(this.getTime());
    }

    public static String toString(long time) {
        int hours = (int)(time / 3600000L);
        int minutes = (int)((time -= (long)(hours * 3600000)) / 60000L);
        int seconds = (int)((time -= (long)(minutes * 60000)) / 1000L);
        int milliseconds = (int)(time -= (long)(seconds * 1000));
        StringBuffer buf = new StringBuffer(32);
        buf.append(hours);
        buf.append(':');
        if (minutes < 10) {
            buf.append('0');
        }
        buf.append(minutes);
        buf.append(':');
        if (seconds < 10) {
            buf.append('0');
        }
        buf.append(seconds);
        buf.append('.');
        if (milliseconds < 10) {
            buf.append("00");
        } else if (milliseconds < 100) {
            buf.append('0');
        }
        buf.append(milliseconds);
        return buf.toString();
    }
}

