/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.reflect.ReflectionException;
import org.apache.commons.lang.reflect.ReflectionUtils;

public class MethodUtils {
    public static final boolean debug = false;
    public static final Method[] EMPTY_METHOD_ARRAY = new Method[0];

    public static Method getMethod(Class cls, String methodName) {
        return MethodUtils.getMethod(cls, methodName, ArrayUtils.EMPTY_CLASS_ARRAY, false);
    }

    public static Method getMethod(Class cls, String methodName, Class paramType) {
        Class[] paramTypes = new Class[]{paramType};
        return MethodUtils.getMethod(cls, methodName, paramTypes);
    }

    public static Method getMethod(Class cls, String methodName, Class[] paramTypes) {
        return MethodUtils.getMethod(cls, methodName, paramTypes, false);
    }

    /*
     * Unable to fully structure code
     */
    public static Method getMethod(Class cls, String methodName, Class[] paramTypes, boolean breakScope) {
        if (cls == null) {
            throw new IllegalArgumentException("The class must not be null");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("The method name must not be null");
        }
        try {
            if (breakScope) {
                try {
                    return cls.getMethod(methodName, paramTypes);
                }
                catch (NoSuchMethodException ex) {
                    acls = cls;
                    ** while (acls != null)
                }
lbl-1000:
                // 1 sources

                {
                    methods = acls.getDeclaredMethods();
                    i = 0;
                    while (i < methods.length) {
                        if (methods[i].getName().equals(methodName) && ReflectionUtils.isCompatible(paramTypes, methods[i].getParameterTypes())) {
                            if (Modifier.isPublic(methods[i].getModifiers())) {
                                methods[i].setAccessible(true);
                            }
                            return methods[i];
                        }
                        ++i;
                    }
                    acls = acls.getSuperclass();
                    continue;
                }
lbl23:
                // 1 sources

                throw new NoSuchMethodException("The method '" + methodName + "' could not be found");
            }
            method = null;
            try {
                method = cls.getMethod(methodName, paramTypes);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            if (method == null && (compatibles = MethodUtils.getCompatibleMethods(cls, methodName, paramTypes)).length > 0) {
                method = compatibles[0];
            }
            return MethodUtils.getMethod(method);
        }
        catch (ReflectionException ex) {
            throw ex;
        }
        catch (LinkageError ex) {
            throw new ReflectionException(ReflectionUtils.getThrowableText(ex, "getting method", cls.getName(), null, methodName), ex);
        }
        catch (Exception ex) {
            throw new ReflectionException(ReflectionUtils.getThrowableText(ex, "getting method", cls.getName(), null, methodName), ex);
        }
    }

    public static Method getMethod(Method method) {
        Method accessibleMethod = MethodUtils.getAccessibleMethod(method);
        if (accessibleMethod == null) {
            try {
                if (ReflectionUtils.isPublicScope(method)) {
                    ((AccessibleObject)method).setAccessible(true);
                    accessibleMethod = method;
                }
            }
            catch (SecurityException se) {
                MethodUtils.log("Cannot setAccessible on method. Therefore cannot use jvm access bug workaround.", se);
            }
        }
        return accessibleMethod;
    }

    public static Object invokeMethod(Object objectToInvoke, String methodName, Object arg) throws ReflectionException {
        if (objectToInvoke == null) {
            throw new IllegalArgumentException("The object to invoke must not be null");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("The method name must not be null");
        }
        if (arg == null) {
            throw new IllegalArgumentException("The argument must not be null");
        }
        Object[] args = new Object[]{arg};
        return MethodUtils.invokeMethod(objectToInvoke, methodName, args);
    }

    public static Object invokeMethod(Object objectToInvoke, String methodName, Object[] args) throws ReflectionException {
        if (objectToInvoke == null) {
            throw new IllegalArgumentException("The object to invoke must not be null");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("The method name must not be null");
        }
        if (args == null) {
            return MethodUtils.invokeMethod(objectToInvoke, methodName, null, null);
        }
        int arguments = args.length;
        Class[] parameterTypes = new Class[arguments];
        int i = 0;
        while (i < arguments) {
            if (args[i] == null) {
                throw new IllegalArgumentException("The arguments must not be null. Index " + i + " was null.");
            }
            parameterTypes[i] = args[i].getClass();
            ++i;
        }
        return MethodUtils.invokeMethod(objectToInvoke, methodName, args, parameterTypes);
    }

    public static Object invokeMethod(Object object, String methodName, Object[] args, Class[] parameterTypes) throws ReflectionException {
        Method method;
        if (parameterTypes == null) {
            parameterTypes = ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        if (args == null) {
            args = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        if ((method = MethodUtils.getMethod(object.getClass(), methodName, parameterTypes)) == null) {
            throw new ReflectionException("No such accessible method: " + methodName + "() on object: " + object.getClass().getName());
        }
        try {
            return method.invoke(object, args);
        }
        catch (IllegalAccessException ex) {
            throw new ReflectionException(ReflectionUtils.getThrowableText(ex, "invoking method", object.getClass().getName(), parameterTypes, methodName), ex);
        }
        catch (InvocationTargetException ex) {
            throw new ReflectionException(ReflectionUtils.getThrowableText(ex, "invoking method", object.getClass().getName(), parameterTypes, methodName), ex);
        }
    }

    private static Method getAccessibleMethod(Method method) {
        if (method == null) {
            return null;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            MethodUtils.log("Method is not public");
            return null;
        }
        Class<?> clazz = method.getDeclaringClass();
        if (Modifier.isPublic(clazz.getModifiers())) {
            MethodUtils.log("Class is public");
            return method;
        }
        String methodName = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        method = MethodUtils.getAccessibleMethodFromInterfaceNest(clazz, method.getName(), method.getParameterTypes());
        return method;
    }

    private static Method getAccessibleMethodFromInterfaceNest(Class clazz, String methodName, Class[] parameterTypes) {
        Method method = null;
        while (clazz != null) {
            Class<?>[] interfaces = clazz.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                if (Modifier.isPublic(interfaces[i].getModifiers())) {
                    try {
                        method = interfaces[i].getDeclaredMethod(methodName, parameterTypes);
                    }
                    catch (NoSuchMethodException e) {
                        // empty catch block
                    }
                    if (method != null || (method = MethodUtils.getAccessibleMethodFromInterfaceNest(interfaces[i], methodName, parameterTypes)) != null) break;
                }
                ++i;
            }
            clazz = clazz.getSuperclass();
        }
        if (method != null) {
            return method;
        }
        return null;
    }

    private static Method[] getCompatibleMethods(Class clazz, String methodName, Class[] parameterTypes) {
        int paramSize = parameterTypes.length;
        Method[] methods = clazz.getMethods();
        ArrayList<Method> compatibles = new ArrayList<Method>(methods.length);
        int i = 0;
        int size = methods.length;
        while (i < size) {
            Class[] methodsParams;
            if (methods[i].getName().equals(methodName) && ReflectionUtils.isCompatible(parameterTypes, methodsParams = methods[i].getParameterTypes())) {
                Method method = MethodUtils.getMethod(methods[i]);
                if (method != null) {
                    compatibles.add(method);
                } else {
                    MethodUtils.log("Couldn't find accessible method for: " + methods[i]);
                }
            }
            ++i;
        }
        return compatibles.toArray(new Method[compatibles.size()]);
    }

    private static void log(Object o) {
    }

    private static void log(Object o, Throwable t) {
    }
}

