/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.functor;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.functor.Predicate;
import org.apache.commons.lang.functor.PredicateException;
import org.apache.commons.lang.functor.Transformer;
import org.apache.commons.lang.functor.TransformerException;
import org.apache.commons.lang.functor.TransformerUtils;

public class PredicateUtils {
    private static final Predicate EXCEPTION_PREDICATE = new ExceptionPredicate();
    private static final Predicate TRUE_PREDICATE = new ConstantPredicate(true);
    private static final Predicate FALSE_PREDICATE = new ConstantPredicate(false);
    private static final Predicate NULL_PREDICATE = new IdentityPredicate(null);
    private static final Predicate NOT_NULL_PREDICATE = new NotPredicate(NULL_PREDICATE);

    protected PredicateUtils() {
    }

    public static Predicate exceptionPredicate() {
        return EXCEPTION_PREDICATE;
    }

    public static Predicate truePredicate() {
        return TRUE_PREDICATE;
    }

    public static Predicate falsePredicate() {
        return FALSE_PREDICATE;
    }

    public static Predicate nullPredicate() {
        return NULL_PREDICATE;
    }

    public static Predicate notNullPredicate() {
        return NOT_NULL_PREDICATE;
    }

    public static Predicate equalPredicate(Object value) {
        if (value == null) {
            return NULL_PREDICATE;
        }
        return new EqualPredicate(value);
    }

    public static Predicate identityPredicate(Object value) {
        if (value == null) {
            return NULL_PREDICATE;
        }
        return new IdentityPredicate(value);
    }

    public static Predicate instanceofPredicate(Class type) {
        if (type == null) {
            throw new IllegalArgumentException("The type to check instanceof must not be null");
        }
        return new InstanceofPredicate(type);
    }

    public static Predicate uniquePredicate() {
        return new UniquePredicate();
    }

    public static Predicate invokerPredicate(String methodName) {
        return PredicateUtils.asPredicate(TransformerUtils.invokerTransformer(methodName));
    }

    public static Predicate invokerPredicate(String methodName, Class[] paramTypes, Object[] args) {
        return PredicateUtils.asPredicate(TransformerUtils.invokerTransformer(methodName, paramTypes, args));
    }

    public static Predicate andPredicate(Predicate predicate1, Predicate predicate2) {
        return PredicateUtils.allPredicate(new Predicate[]{predicate1, predicate2});
    }

    public static Predicate allPredicate(Predicate[] predicates) {
        return new AllPredicate(PredicateUtils.validate(predicates));
    }

    public static Predicate allPredicate(Collection predicates) {
        return new AllPredicate(PredicateUtils.validate(predicates));
    }

    public static Predicate orPredicate(Predicate predicate1, Predicate predicate2) {
        return PredicateUtils.anyPredicate(new Predicate[]{predicate1, predicate2});
    }

    public static Predicate anyPredicate(Predicate[] predicates) {
        return new AnyPredicate(PredicateUtils.validate(predicates));
    }

    public static Predicate anyPredicate(Collection predicates) {
        return new AnyPredicate(PredicateUtils.validate(predicates));
    }

    public static Predicate eitherPredicate(Predicate predicate1, Predicate predicate2) {
        return PredicateUtils.onePredicate(new Predicate[]{predicate1, predicate2});
    }

    public static Predicate onePredicate(Predicate[] predicates) {
        return new OnePredicate(PredicateUtils.validate(predicates));
    }

    public static Predicate onePredicate(Collection predicates) {
        return new OnePredicate(PredicateUtils.validate(predicates));
    }

    public static Predicate neitherPredicate(Predicate predicate1, Predicate predicate2) {
        return PredicateUtils.nonePredicate(new Predicate[]{predicate1, predicate2});
    }

    public static Predicate nonePredicate(Predicate[] predicates) {
        Predicate[] preds = PredicateUtils.validate(predicates);
        int i = 0;
        while (i < preds.length) {
            preds[i] = PredicateUtils.notPredicate(preds[i]);
            ++i;
        }
        return new AllPredicate(preds);
    }

    public static Predicate nonePredicate(Collection predicates) {
        Predicate[] preds = PredicateUtils.validate(predicates);
        int i = 0;
        while (i < preds.length) {
            preds[i] = PredicateUtils.notPredicate(preds[i]);
            ++i;
        }
        return new AllPredicate(preds);
    }

    public static Predicate notPredicate(Predicate predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException("The predicate must not be null");
        }
        return new NotPredicate(predicate);
    }

    public static Predicate asPredicate(Transformer transformer) {
        if (transformer == null) {
            throw new IllegalArgumentException("The transformer to call must not be null");
        }
        return new TransformerPredicate(transformer);
    }

    public static Predicate nullIsExceptionPredicate(Predicate predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException("The predicate must not be null");
        }
        return new NullIsExceptionPredicate(predicate);
    }

    public static Predicate nullIsFalsePredicate(Predicate predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException("The predicate must not be null");
        }
        return new NullIsFalsePredicate(predicate);
    }

    public static Predicate nullIsTruePredicate(Predicate predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException("The predicate must not be null");
        }
        return new NullIsTruePredicate(predicate);
    }

    private static Predicate[] validate(Collection predicates) {
        if (predicates == null) {
            throw new IllegalArgumentException("The predicate collection must not be null");
        }
        if (predicates.size() < 2) {
            throw new IllegalArgumentException("At least 2 predicates must be specified in the predicate collection, size was " + predicates.size());
        }
        Predicate[] preds = new Predicate[predicates.size()];
        int i = 0;
        Iterator it = predicates.iterator();
        while (it.hasNext()) {
            preds[i] = (Predicate)it.next();
            if (preds[i] == null) {
                throw new IllegalArgumentException("The predicate collection must not contain a null predicate, index " + i + " was null");
            }
            ++i;
        }
        return preds;
    }

    private static Predicate[] validate(Predicate[] predicates) {
        if (predicates == null) {
            throw new IllegalArgumentException("The predicate array must not be null");
        }
        if (predicates.length < 2) {
            throw new IllegalArgumentException("At least 2 predicates must be specified in the predicate array, size was " + predicates.length);
        }
        Predicate[] preds = new Predicate[predicates.length];
        int i = 0;
        while (i < predicates.length) {
            if (predicates[i] == null) {
                throw new IllegalArgumentException("The predicate array must not contain a null predicate, index " + i + " was null");
            }
            preds[i] = predicates[i];
            ++i;
        }
        return preds;
    }

    private static class NullIsTruePredicate
    implements Predicate,
    Serializable {
        private final Predicate iPredicate;

        private NullIsTruePredicate(Predicate predicate) {
            this.iPredicate = predicate;
        }

        public boolean evaluate(Object object) {
            if (object == null) {
                return true;
            }
            return this.iPredicate.evaluate(object);
        }
    }

    private static class NullIsFalsePredicate
    implements Predicate,
    Serializable {
        private final Predicate iPredicate;

        private NullIsFalsePredicate(Predicate predicate) {
            this.iPredicate = predicate;
        }

        public boolean evaluate(Object object) {
            if (object == null) {
                return false;
            }
            return this.iPredicate.evaluate(object);
        }
    }

    private static class NullIsExceptionPredicate
    implements Predicate,
    Serializable {
        private final Predicate iPredicate;

        private NullIsExceptionPredicate(Predicate predicate) {
            this.iPredicate = predicate;
        }

        public boolean evaluate(Object object) {
            if (object == null) {
                throw new PredicateException("NullIsExceptionPredicate: Input Object must not be null");
            }
            return this.iPredicate.evaluate(object);
        }
    }

    private static class TransformerPredicate
    implements Predicate,
    Serializable {
        private final Transformer iTransformer;

        public TransformerPredicate(Transformer transformer) {
            this.iTransformer = transformer;
        }

        public boolean evaluate(Object object) {
            Object result = null;
            try {
                result = this.iTransformer.transform(object);
            }
            catch (TransformerException ex) {
                throw new PredicateException("TransformerPredicate: " + ex.getMessage(), ex);
            }
            if (!(result instanceof Boolean)) {
                throw new PredicateException("TransformerPredicate: Transformer must return an instanceof Boolean, it was a " + (result == null ? "null object" : result.getClass().getName()));
            }
            return (Boolean)result;
        }
    }

    private static class UniquePredicate
    implements Predicate,
    Serializable {
        private final Set iSet = new HashSet();

        public boolean evaluate(Object object) {
            return this.iSet.add(object);
        }
    }

    private static class IdentityPredicate
    implements Predicate,
    Serializable {
        private final Object iValue;

        public IdentityPredicate(Object value) {
            this.iValue = value;
        }

        public boolean evaluate(Object object) {
            return this.iValue == object;
        }
    }

    private static class EqualPredicate
    implements Predicate,
    Serializable {
        private final Object iValue;

        public EqualPredicate(Object value) {
            this.iValue = value;
        }

        public boolean evaluate(Object object) {
            return this.iValue.equals(object);
        }
    }

    private static class InstanceofPredicate
    implements Predicate,
    Serializable {
        private final Class iType;

        public InstanceofPredicate(Class type) {
            this.iType = type;
        }

        public boolean evaluate(Object object) {
            return this.iType.isInstance(object);
        }
    }

    private static class NotPredicate
    implements Predicate,
    Serializable {
        private final Predicate iPredicate;

        private NotPredicate(Predicate predicate) {
            this.iPredicate = predicate;
        }

        public boolean evaluate(Object object) {
            return !this.iPredicate.evaluate(object);
        }
    }

    private static class OnePredicate
    implements Predicate,
    Serializable {
        private final Predicate[] iPredicates;

        private OnePredicate(Predicate[] predicates) {
            this.iPredicates = predicates;
        }

        public boolean evaluate(Object object) {
            boolean match = false;
            int i = 0;
            while (i < this.iPredicates.length) {
                if (this.iPredicates[i].evaluate(object)) {
                    if (match) {
                        return false;
                    }
                    match = true;
                }
                ++i;
            }
            return match;
        }
    }

    private static class AnyPredicate
    implements Predicate,
    Serializable {
        private final Predicate[] iPredicates;

        private AnyPredicate(Predicate[] predicates) {
            this.iPredicates = predicates;
        }

        public boolean evaluate(Object object) {
            int i = 0;
            while (i < this.iPredicates.length) {
                if (this.iPredicates[i].evaluate(object)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    private static class AllPredicate
    implements Predicate,
    Serializable {
        private final Predicate[] iPredicates;

        private AllPredicate(Predicate[] predicates) {
            this.iPredicates = predicates;
        }

        public boolean evaluate(Object object) {
            int i = 0;
            while (i < this.iPredicates.length) {
                if (!this.iPredicates[i].evaluate(object)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    private static class ConstantPredicate
    implements Predicate,
    Serializable {
        private final boolean iConstant;

        private ConstantPredicate(boolean constant) {
            this.iConstant = constant;
        }

        public boolean evaluate(Object object) {
            return this.iConstant;
        }
    }

    private static class ExceptionPredicate
    implements Predicate,
    Serializable {
        private ExceptionPredicate() {
        }

        public boolean evaluate(Object object) {
            throw new PredicateException("ExceptionPredicate invoked");
        }
    }
}

