/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.functor;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang.SerializationException;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.functor.Factory;
import org.apache.commons.lang.functor.FactoryException;

public class FactoryUtils {
    private static final Factory EXCEPTION_FACTORY = new ExceptionFactory();
    private static final Factory NULL_FACTORY = new ConstantFactory(null);

    protected FactoryUtils() {
    }

    public static Factory exceptionFactory() {
        return EXCEPTION_FACTORY;
    }

    public static Factory nullFactory() {
        return NULL_FACTORY;
    }

    public static Factory constantFactory(Object constantToReturn) {
        return new ConstantFactory(constantToReturn);
    }

    public static Factory prototypeFactory(Object prototype) {
        if (prototype == null) {
            throw new IllegalArgumentException("The prototype must not be null");
        }
        try {
            prototype.getClass().getMethod("clone", null);
            return new PrototypeCloneFactory(prototype);
        }
        catch (NoSuchMethodException ex) {
            try {
                prototype.getClass().getConstructor(prototype.getClass());
                return new ReflectionFactory(prototype.getClass(), new Class[]{prototype.getClass()}, new Object[]{prototype});
            }
            catch (NoSuchMethodException ex2) {
                if (prototype instanceof Serializable) {
                    return new PrototypeSerializationFactory((Serializable)prototype);
                }
                throw new IllegalArgumentException("The prototype must be cloneable via a public clone method");
            }
        }
    }

    public static Factory reflectionFactory(Class classToInstantiate) {
        return new ReflectionFactory(classToInstantiate);
    }

    public static Factory reflectionFactory(Class classToInstantiate, Class[] paramTypes, Object[] args) {
        return new ReflectionFactory(classToInstantiate, paramTypes, args);
    }

    private static class ReflectionFactory
    implements Factory,
    Serializable {
        private final Class iClassToInstantiate;
        private final Class[] iParamTypes;
        private final Object[] iArgs;
        private transient Constructor iConstructor = null;

        public ReflectionFactory(Class classToInstantiate) {
            this(classToInstantiate, null, null);
        }

        public ReflectionFactory(Class classToInstantiate, Class[] paramTypes, Object[] args) {
            if (classToInstantiate == null) {
                throw new IllegalArgumentException("ReflectionFactory: The class to instantiate must not be null");
            }
            if (paramTypes == null && args != null || paramTypes != null && args == null || paramTypes != null && args != null && paramTypes.length != args.length) {
                throw new IllegalArgumentException("ReflectionFactory: The parameter types must match the arguments");
            }
            this.iClassToInstantiate = classToInstantiate;
            if (paramTypes == null && args == null) {
                this.iParamTypes = null;
                this.iArgs = null;
            } else {
                this.iParamTypes = (Class[])paramTypes.clone();
                this.iArgs = (Object[])args.clone();
            }
            this.findConstructor();
        }

        private void findConstructor() {
            try {
                this.iConstructor = this.iClassToInstantiate.getConstructor(this.iParamTypes);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalArgumentException("ReflectionFactory: The constructor must exist and be public ");
            }
        }

        public Object create() {
            if (this.iConstructor == null) {
                this.findConstructor();
            }
            try {
                return this.iConstructor.newInstance(this.iArgs);
            }
            catch (InstantiationException ex) {
                throw new FactoryException("ReflectionFactory: InstantiationException", ex);
            }
            catch (IllegalAccessException ex) {
                throw new FactoryException("ReflectionFactory: Constructor must be public", ex);
            }
            catch (InvocationTargetException ex) {
                throw new FactoryException("ReflectionFactory: Constructor threw an exception", ex);
            }
        }
    }

    private static class PrototypeSerializationFactory
    implements Factory,
    Serializable {
        private final Serializable iPrototype;

        private PrototypeSerializationFactory(Serializable prototype) {
            if (prototype == null) {
                throw new IllegalArgumentException("PrototypeSerializationFactory: The prototype must not be null");
            }
            this.iPrototype = prototype;
        }

        public Object create() {
            try {
                return SerializationUtils.clone(this.iPrototype);
            }
            catch (SerializationException ex) {
                throw new FactoryException("PrototypeSerializationFactory: Unable to clone by serialization", ex);
            }
        }
    }

    private static class PrototypeCloneFactory
    implements Factory,
    Serializable {
        private final Object iPrototype;
        private transient Method iCloneMethod;

        private PrototypeCloneFactory(Object prototype) {
            if (prototype == null) {
                throw new IllegalArgumentException("PrototypeCloneFactory: The prototype must not be null");
            }
            this.iPrototype = prototype;
            this.findCloneMethod();
        }

        private void findCloneMethod() {
            try {
                this.iCloneMethod = this.iPrototype.getClass().getMethod("clone", null);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalArgumentException("PrototypeCloneFactory: The clone method must exist and be public ");
            }
        }

        public Object create() {
            if (this.iCloneMethod == null) {
                this.findCloneMethod();
            }
            try {
                return this.iCloneMethod.invoke(this.iPrototype, null);
            }
            catch (IllegalAccessException ex) {
                throw new FactoryException("ReflectionFactory: Clone method must be public", ex);
            }
            catch (InvocationTargetException ex) {
                throw new FactoryException("ReflectionFactory: Clone method threw an exception", ex);
            }
        }
    }

    private static class ConstantFactory
    implements Factory,
    Serializable {
        private final Object iConstant;

        private ConstantFactory(Object constant) {
            this.iConstant = constant;
        }

        public Object create() {
            return this.iConstant;
        }
    }

    private static class ExceptionFactory
    implements Factory,
    Serializable {
        private ExceptionFactory() {
        }

        public Object create() {
            throw new FactoryException("ExceptionFactory invoked");
        }
    }
}

